/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.core.runtime.IProgressMonitor;

public class FilterSettings
implements IFilterSettings {
    private List<IFilter> filters = new ArrayList<IFilter>();
    private boolean onlySelected = true;
    private boolean resetSelectedRetentionTimes = true;

    public FilterSettings() {
    }

    public FilterSettings(IFilterSettings filterSettings) {
        for (IFilter filter : filterSettings.getFilters()) {
            this.filters.add(filter);
        }
        this.onlySelected = filterSettings.isOnlySelected();
        this.resetSelectedRetentionTimes = filterSettings.isResetSelectedRetentionTimes();
    }

    @Override
    public boolean availableModification() {
        return !this.filters.isEmpty();
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public boolean isOnlySelected() {
        return this.onlySelected;
    }

    @Override
    public boolean isResetSelectedRetentionTimes() {
        return this.resetSelectedRetentionTimes;
    }

    @Override
    public void setResetSelectedRetentionTimes(boolean resetSelectedRetentionTimes) {
        this.resetSelectedRetentionTimes = resetSelectedRetentionTimes;
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples, IProgressMonitor monitor) {
        List variables = samples.getVariables();
        if (this.resetSelectedRetentionTimes) {
            this.setSelect(samples, true);
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            int i = 0;
            while (i < this.filters.size()) {
                this.filters.get(i).setOnlySelected(this.onlySelected);
                List<Boolean> result = this.filters.get(i).filter(samples);
                int j = 0;
                while (j < result.size()) {
                    ((IVariable)variables.get(j)).setSelected(((IVariable)variables.get(j)).isSelected() && result.get(j) != false);
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void setOnlySelected(boolean onlySelected) {
        this.onlySelected = onlySelected;
    }

    private <V extends IVariable, S extends ISample> void setSelect(ISamples<V, S> samples, boolean selection) {
        List variables = samples.getVariables();
        int i = 0;
        while (i < variables.size()) {
            ((IVariable)variables.get(i)).setSelected(selection);
            ++i;
        }
    }
}

