/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.chemclipse.support.text.ValueFormat;

public class ResultExport {
    private static final String TAB = "\t";
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public void exportToTextFile(File file, IResultsPCA<?, ?> pcaResults, List<IDataInputEntry> dataInputEntries) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(file);
        if (pcaResults != null) {
            int n;
            int n2;
            double[] dArray;
            String name;
            String variable;
            printWriter.println("-------------------------------------");
            printWriter.println("Settings");
            printWriter.println("-------------------------------------");
            printWriter.print("Number of principal components:");
            printWriter.print(TAB);
            printWriter.println(pcaResults.getPcaSettings().getNumberOfPrincipalComponents());
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Input Files");
            printWriter.println("-------------------------------------");
            for (IDataInputEntry entry : dataInputEntries) {
                printWriter.print(entry.getFileName());
                printWriter.print(TAB);
                printWriter.println(entry.getInputFile());
            }
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Extracted Retention Times (Minutes)");
            printWriter.println("-------------------------------------");
            int i = 0;
            while (i < pcaResults.getExtractedVariables().size()) {
                variable = ((IVariable)pcaResults.getExtractedVariables().get(i)).getValue();
                printWriter.println(variable);
                ++i;
            }
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Input Data Table");
            printWriter.println("-------------------------------------");
            printWriter.print("Filename");
            printWriter.print(TAB);
            i = 0;
            while (i < pcaResults.getExtractedVariables().size()) {
                variable = ((IVariable)pcaResults.getExtractedVariables().get(i)).getValue();
                printWriter.println(variable);
                printWriter.print(TAB);
                ++i;
            }
            printWriter.println("");
            for (IResultPCA pcaResult : pcaResults.getPcaResultList()) {
                double[] sampleData;
                name = pcaResult.getName();
                printWriter.print(name);
                printWriter.print(TAB);
                dArray = sampleData = pcaResult.getSampleData();
                n2 = sampleData.length;
                n = 0;
                while (n < n2) {
                    double data = dArray[n];
                    printWriter.print(this.decimalFormat.format(data));
                    printWriter.print(TAB);
                    ++n;
                }
                printWriter.println("");
            }
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Principal Components");
            printWriter.println("-------------------------------------");
            printWriter.print("File");
            printWriter.print(TAB);
            i = 1;
            while (i <= pcaResults.getPcaSettings().getNumberOfPrincipalComponents()) {
                printWriter.print("PC" + i);
                printWriter.print(TAB);
                ++i;
            }
            printWriter.println("");
            for (IResultPCA pcaResult : pcaResults.getPcaResultList()) {
                name = pcaResult.getName();
                double[] eigenSpace = pcaResult.getScoreVector();
                printWriter.print(name);
                printWriter.print(TAB);
                dArray = eigenSpace;
                n2 = eigenSpace.length;
                n = 0;
                while (n < n2) {
                    double value = dArray[n];
                    printWriter.print(this.decimalFormat.format(value));
                    printWriter.print(TAB);
                    ++n;
                }
                printWriter.println("");
            }
        } else {
            printWriter.println("There are no results available yet.");
        }
        printWriter.flush();
        printWriter.close();
    }
}

