/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;

public abstract class AbstractMagicNumberMatcher
implements IMagicNumberMatcher {
    protected boolean checkFileExtension(File file, String extension) {
        return this.checkFileExtension(file, extension, false);
    }

    protected boolean checkFileExtension(File file, String extension, boolean caseSensitive) {
        String fileExtension = caseSensitive ? file.getName() : file.getName().toLowerCase();
        return fileExtension.endsWith(caseSensitive ? extension : extension.toLowerCase());
    }

    protected boolean checkFileName(File file, String regex) {
        return file.getName().matches(regex);
    }

    protected boolean checkMagicCode(File file, byte[] magicCode) {
        if (magicCode.length == 0 || file.length() < (long)magicCode.length) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                byte[] input = new byte[magicCode.length];
                ((InputStream)inputStream).read(input);
                return Arrays.equals(input, magicCode);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkPattern(File file, int length, Map<Integer, Byte> indexMap) {
        if (length <= 0) return false;
        if (indexMap.size() == 0) return false;
        if (file.length() < (long)length) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                int index;
                byte[] input = new byte[length];
                ((InputStream)inputStream).read(input);
                Set<Integer> indices = indexMap.keySet();
                int maxIndex = length - 1;
                Iterator<Integer> iterator = indices.iterator();
                do {
                    if (!iterator.hasNext()) {
                        return true;
                    }
                    index = iterator.next();
                    if (index < 0) return false;
                    if (index > maxIndex) return false;
                } while (input[index] == indexMap.get(index));
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

