/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface IFileHelper {
    public String getBaseFileDirectory(File var1);

    public String getBaseFileName(File var1);

    public static void writeStringCollection(DataOutputStream dataOutputStream, Collection<String> collection) throws IOException {
        if (collection == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(collection.size());
            for (String string : collection) {
                IFileHelper.writeString(dataOutputStream, string);
            }
        }
    }

    public static void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        if (value == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(value.length());
            dataOutputStream.writeChars(value);
        }
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        int size = dataInputStream.readInt();
        if (size > -1) {
            char[] buffer = new char[size];
            int i = 0;
            while (i < buffer.length) {
                buffer[i] = dataInputStream.readChar();
                ++i;
            }
            return new String(buffer);
        }
        return null;
    }

    public static List<String> readStringCollection(DataInputStream dataInputStream) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        int size = dataInputStream.readInt();
        if (size > -1) {
            list.ensureCapacity(size);
            int i = 0;
            while (i < size) {
                list.add(IFileHelper.readString(dataInputStream));
                ++i;
            }
        }
        return list;
    }
}

