/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.methods;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.methods.IMethodExportConverter;
import org.eclipse.chemclipse.converter.methods.IMethodImportConverter;
import org.eclipse.chemclipse.converter.methods.MethodConverterSupport;
import org.eclipse.chemclipse.converter.methods.MethodSupplier;
import org.eclipse.chemclipse.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;

public class MethodConverter {
    private static final String NAME_IMPORT = "Method Import Converter";
    private static final String NAME_EXPORT = "Method Export Converter";
    private static final int STREAM_BUFFER_SIZE = 0x500000;
    public static final String DEFAULT_METHOD_CONVERTER_ID = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.processMethodSupplier";
    public static final String DEFAULT_METHOD_FILE_NAME_EXTENSION = "ocm";
    public static final String DEFAULT_METHOD_FILE_NAME = "ProcessMethod.ocm";
    public static final String[] DEFAULT_METHOD_FILE_EXTENSIONS = new String[]{"*.ocm"};
    public static final String[] DEFAULT_METHOD_FILE_NAMES = new String[]{"Process Method (*.ocm)"};
    private static final Logger logger = Logger.getLogger(MethodConverter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.converter.processMethodSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String FILE_NAME = "fileName";
    private static final String IMPORT_CONVERTER = "importConverter";
    private static final String EXPORT_CONVERTER = "exportConverter";
    private static final String IS_EXPORTABLE = "isExportable";
    private static final String IS_IMPORTABLE = "isImportable";
    private static final String IMPORT_MAGIC_NUMBER_MATCHER = "importMagicNumberMatcher";

    private MethodConverter() {
    }

    public static IProcessingInfo<IProcessMethod> convert(File file, IProgressMonitor monitor) {
        MethodConverterSupport converterSupport = MethodConverter.getMethodConverterSupport();
        for (ISupplier supplier : converterSupport.getSupplier()) {
            IProcessingInfo<IProcessMethod> processinInfo = MethodConverter.convert(file, supplier.getId(), monitor);
            IProcessMethod processMethod = (IProcessMethod)processinInfo.getProcessingResult();
            if (processMethod == null) continue;
            return processinInfo;
        }
        return MethodConverter.getNoImportConverterAvailableProcessingInfo(file);
    }

    public static IProcessingInfo<IProcessMethod> convert(File file, String converterId, IProgressMonitor monitor) {
        Object processingInfo;
        IMethodImportConverter importConverter = MethodConverter.getMethodImportConverter(converterId);
        if (importConverter != null) {
            try {
                processingInfo = importConverter.convert(file, monitor);
            }
            catch (IOException e) {
                ProcessingInfo info = new ProcessingInfo();
                info.addErrorMessage(NAME_IMPORT, "can't read file " + file, (Throwable)e);
                return info;
            }
        } else {
            processingInfo = MethodConverter.getNoImportConverterAvailableProcessingInfo(file);
        }
        return processingInfo;
    }

    public static IProcessingInfo<IProcessMethod> load(InputStream stream, String nameHint, IProgressMonitor monitor) throws IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream, 0x500000);
        }
        MethodConverterSupport converterSupport = MethodConverter.getMethodConverterSupport();
        List<ISupplier> list = converterSupport.getSupplier();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(list.size() * 100));
        IProcessingInfo errors = MethodConverter.getNoImportConverterAvailableProcessingInfo(nameHint);
        for (ISupplier supplier : list) {
            IProcessingInfo<IProcessMethod> info;
            IMethodImportConverter converter = MethodConverter.getMethodImportConverter(supplier.getId());
            if (converter == null || (info = converter.readFrom(stream, nameHint, (IProgressMonitor)subMonitor.split(100))) == null) continue;
            if (info.hasErrorMessages() || info.getProcessingResult() == null) {
                errors.addMessages(info);
                continue;
            }
            return info;
        }
        return errors;
    }

    public static void store(OutputStream stream, String nameHint, IProcessMethod processMethod, MessageConsumer consumer, IProgressMonitor monitor) throws IOException {
        MethodConverter.store(stream, nameHint, processMethod, DEFAULT_METHOD_CONVERTER_ID, consumer, monitor);
    }

    public static void store(OutputStream stream, String nameHint, IProcessMethod processMethod, String converterId, MessageConsumer consumer, IProgressMonitor monitor) throws IOException {
        MethodConverterSupport converterSupport = MethodConverter.getMethodConverterSupport();
        for (ISupplier supplier : converterSupport.getSupplier()) {
            if (!supplier.isExportable() || !supplier.getId().equals(converterId)) continue;
            IMethodExportConverter exportConverter = MethodConverter.getMethodExportConverter(converterId);
            exportConverter.convert(stream, nameHint, processMethod, consumer, monitor);
            return;
        }
        consumer.addMessages(MethodConverter.getNoExportConverterAvailableProcessingInfo(nameHint));
    }

    public static IProcessingInfo<Void> convert(File file, IProcessMethod processMethod, String converterId, IProgressMonitor monitor) {
        MethodConverterSupport converterSupport = MethodConverter.getMethodConverterSupport();
        for (ISupplier supplier : converterSupport.getSupplier()) {
            if (!supplier.isExportable() || !supplier.getId().equals(converterId)) continue;
            ProcessingInfo processingInfo = new ProcessingInfo();
            IMethodExportConverter exportConverter = MethodConverter.getMethodExportConverter(converterId);
            try {
                exportConverter.convert(file, processMethod, (MessageConsumer)processingInfo, monitor);
            }
            catch (IOException e) {
                ProcessingInfo info = new ProcessingInfo();
                info.addErrorMessage(NAME_EXPORT, "can't write file " + file, (Throwable)e);
                return info;
            }
            return processingInfo;
        }
        return MethodConverter.getNoExportConverterAvailableProcessingInfo(file);
    }

    private static IMethodImportConverter getMethodImportConverter(String converterId) {
        IConfigurationElement element = MethodConverter.getConfigurationElement(converterId);
        IMethodImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IMethodImportConverter)element.createExecutableExtension(IMPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IMethodExportConverter getMethodExportConverter(String converterId) {
        IConfigurationElement element = MethodConverter.getConfigurationElement(converterId);
        IMethodExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IMethodExportConverter)element.createExecutableExtension(EXPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static MethodConverterSupport getMethodConverterSupport() {
        IConfigurationElement[] extensions;
        MethodConverterSupport converterSupport = new MethodConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MethodSupplier supplier = new MethodSupplier();
            supplier.setFileExtension(element.getAttribute(FILE_EXTENSION));
            supplier.setFileName(element.getAttribute(FILE_NAME));
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            supplier.setExportable(Boolean.valueOf(element.getAttribute(IS_EXPORTABLE)));
            supplier.setImportable(Boolean.valueOf(element.getAttribute(IS_IMPORTABLE)));
            supplier.setMagicNumberMatcher(MethodConverter.getMagicNumberMatcher(element));
            converterSupport.add(supplier);
            ++n2;
        }
        return converterSupport;
    }

    private static <T> IProcessingInfo<T> getNoImportConverterAvailableProcessingInfo(File file) {
        return MethodConverter.getNoImportConverterAvailableProcessingInfo("the file: " + file.getAbsolutePath());
    }

    private static <T> IProcessingInfo<T> getNoImportConverterAvailableProcessingInfo(String hint) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage(NAME_IMPORT, "There is no suitable converter available to load the method from " + hint);
        return processingInfo;
    }

    private static <T> IProcessingInfo<T> getNoExportConverterAvailableProcessingInfo(File file) {
        return MethodConverter.getNoExportConverterAvailableProcessingInfo("the file: " + file.getAbsolutePath());
    }

    private static <T> IProcessingInfo<T> getNoExportConverterAvailableProcessingInfo(String nameHint) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage(NAME_EXPORT, "There is no suitable converter available to write the method to " + nameHint);
        return processingInfo;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension(IMPORT_MAGIC_NUMBER_MATCHER);
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }

    public static Collection<IProcessMethod> getUserMethods() {
        ArrayList<IProcessMethod> methodFiles = new ArrayList<IProcessMethod>();
        File directory = MethodConverter.getUserMethodDirectory();
        if (directory.exists() && directory.isDirectory()) {
            try {
                String[] extensions = MethodConverter.getMethodConverterSupport().getFilterExtensions();
                File[] fileArray = directory.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String[] stringArray = extensions;
                    int n3 = extensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProcessMethod adapt;
                        String extension = stringArray[n4];
                        if (file.getName().toLowerCase().endsWith(extension.toLowerCase()) && (adapt = (IProcessMethod)Adapters.adapt((Object)file, IProcessMethod.class)) != null) {
                            methodFiles.add(adapt);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (NoConverterAvailableException noConverterAvailableException) {
                // empty catch block
            }
        }
        return methodFiles;
    }

    public static File getUserMethodDirectory() {
        return new File(PreferenceSupplier.getSettings("methodExplorerPathRootFolder", ""));
    }

    public static void setUserMethodDirectory(File file) {
        if (file != null) {
            String directory = file.isDirectory() ? file.getAbsolutePath() : file.getParent();
            PreferenceSupplier.setSettings("methodExplorerPathRootFolder", directory);
        }
    }
}

