/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.converter.Activator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceSupplier
implements IPreferenceSupplier {
    private static final Logger logger = Logger.getLogger(PreferenceSupplier.class);
    public static final String P_LIST_PATH_IMPORT = "listPathImport";
    public static final String DEF_LIST_PATH_IMPORT = "";
    public static final String P_LIST_PATH_EXPORT = "listPathExport";
    public static final String DEF_LIST_PATH_EXPORT = "";
    public static final String P_CHROMATOGRAM_EXPORT_FOLDER = "chromatogramExportFolder";
    public static final String DEF_CHROMATOGRAM_EXPORT_FOLDER = "";
    public static final String P_METHOD_EXPLORER_PATH_ROOT_FOLDER = "methodExplorerPathRootFolder";
    public static final String DEF_METHOD_EXPLORER_PATH_ROOT_FOLDER = "";
    public static final String P_SELECTED_METHOD_NAME = "selectedMethodName";
    public static final String DEF_SELECTED_METHOD_NAME = "";
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_LIST_PATH_IMPORT, "");
        defaultValues.put(P_LIST_PATH_EXPORT, "");
        defaultValues.put(P_CHROMATOGRAM_EXPORT_FOLDER, "");
        defaultValues.put(P_METHOD_EXPLORER_PATH_ROOT_FOLDER, "");
        defaultValues.put(P_SELECTED_METHOD_NAME, "");
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static String getSettings(String key, String def) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(key, def);
    }

    public static String getListPathImport() {
        return PreferenceSupplier.getFilterPath(P_LIST_PATH_IMPORT, "");
    }

    public static void setListPathImport(String filterPath) {
        PreferenceSupplier.setSettings(P_LIST_PATH_IMPORT, filterPath);
    }

    public static String getListPathExport() {
        return PreferenceSupplier.getFilterPath(P_LIST_PATH_EXPORT, "");
    }

    public static void setListPathExport(String filterPath) {
        PreferenceSupplier.setSettings(P_LIST_PATH_EXPORT, filterPath);
    }

    public static String getChromatogramExportFolder() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_CHROMATOGRAM_EXPORT_FOLDER, "");
    }

    public static String getSelectedMethodName() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_SELECTED_METHOD_NAME, "");
    }

    public static void setSelectedMethodName(String methodName) {
        PreferenceSupplier.setSettings(P_SELECTED_METHOD_NAME, methodName);
    }

    public static void setSettings(String key, String value) {
        try {
            IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
            preferences.put(key, value);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            logger.warn((Object)e);
        }
    }

    private static String getFilterPath(String key, String def) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(key, def);
    }
}

