/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.support.IIntegrationConstraints;
import org.eclipse.chemclipse.model.support.IntegrationConstraints;

public abstract class AbstractPeak
implements IPeak {
    private String modelDescription = "";
    private PeakType peakType = PeakType.DEFAULT;
    private int suggestedNumberOfComponents = 0;
    private String integratorDescription = "";
    private String detectorDescription = "";
    private String quantifierDescription = "";
    private boolean activeForAnalysis = true;
    private List<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
    private final IIntegrationConstraints integrationConstraints = new IntegrationConstraints();
    private final Set<IQuantitationEntry> quantitationEntries = new HashSet<IQuantitationEntry>();
    private final List<IInternalStandard> internalStandards = new ArrayList<IInternalStandard>();
    private final List<String> quantitationReferences = new ArrayList<String>();
    private final Set<String> classifier = new LinkedHashSet<String>();
    private String name;

    @Override
    public String getModelDescription() {
        return this.modelDescription;
    }

    @Override
    public void setModelDescription(String modelDescription) {
        if (modelDescription != null) {
            this.modelDescription = modelDescription;
        }
    }

    @Override
    public PeakType getPeakType() {
        return this.peakType;
    }

    @Override
    public void setPeakType(PeakType peakType) {
        if (peakType != null) {
            this.peakType = peakType;
        }
    }

    @Override
    public int getSuggestedNumberOfComponents() {
        return this.suggestedNumberOfComponents;
    }

    @Override
    public void setSuggestedNumberOfComponents(int suggestedNumberOfComponents) {
        this.suggestedNumberOfComponents = suggestedNumberOfComponents;
    }

    @Override
    public String getIntegratorDescription() {
        return this.integratorDescription;
    }

    @Override
    public void setIntegratorDescription(String integratorDescription) {
        if (integratorDescription != null) {
            this.integratorDescription = integratorDescription;
        }
    }

    @Override
    public String getDetectorDescription() {
        return this.detectorDescription;
    }

    @Override
    public void setDetectorDescription(String detectorDescription) {
        if (detectorDescription != null) {
            this.detectorDescription = detectorDescription;
        }
    }

    @Override
    public IIntegrationConstraints getIntegrationConstraints() {
        return this.integrationConstraints;
    }

    @Override
    public double getIntegratedArea() {
        double integratedArea = 0.0;
        if (this.integrationEntries.size() > 0) {
            for (IIntegrationEntry integrationEntry : this.integrationEntries) {
                integratedArea += integrationEntry.getIntegratedArea();
            }
        }
        return integratedArea;
    }

    @Override
    public List<IIntegrationEntry> getIntegrationEntries() {
        return Collections.unmodifiableList(this.integrationEntries);
    }

    @Override
    public void addAllIntegrationEntries(Collection<? extends IIntegrationEntry> integrationEntries) {
        this.integrationEntries.addAll(integrationEntries);
    }

    @Override
    public void addAllIntegrationEntries(IIntegrationEntry ... integrationEntries) {
        this.addAllIntegrationEntries(Arrays.asList(integrationEntries));
    }

    @Override
    public void setIntegratedArea(List<? extends IIntegrationEntry> integrationEntries, String integratorDescription) {
        if (integrationEntries != null) {
            this.setIntegratorDescription(integratorDescription);
            this.integrationEntries = new ArrayList<IIntegrationEntry>(integrationEntries);
        }
    }

    @Override
    public String getQuantifierDescription() {
        return this.quantifierDescription;
    }

    @Override
    public void setQuantifierDescription(String quantifierDescription) {
        this.quantifierDescription = quantifierDescription;
    }

    @Override
    public void addQuantitationEntry(IQuantitationEntry quantitationEntry) {
        this.quantitationEntries.add(quantitationEntry);
    }

    @Override
    public void addAllQuantitationEntries(IQuantitationEntry ... quantitationEntries) {
        this.addAllQuantitationEntries(Arrays.asList(quantitationEntries));
    }

    @Override
    public void addAllQuantitationEntries(Collection<? extends IQuantitationEntry> quantitationEntries) {
        this.quantitationEntries.addAll(quantitationEntries);
    }

    @Override
    public void removeQuantitationEntry(IQuantitationEntry quantitationEntry) {
        this.quantitationEntries.remove(quantitationEntry);
    }

    @Override
    public void removeQuantitationEntries(List<IQuantitationEntry> quantitationEntriesToRemove) {
        this.quantitationEntries.removeAll(quantitationEntriesToRemove);
    }

    @Override
    public List<IQuantitationEntry> getQuantitationEntries() {
        return Collections.unmodifiableList(new ArrayList<IQuantitationEntry>(this.quantitationEntries));
    }

    @Override
    public void removeAllQuantitationEntries() {
        this.quantitationEntries.clear();
    }

    @Override
    public void removeAllIntegrationEntries() {
        this.integrationEntries.clear();
    }

    @Override
    public boolean isActiveForAnalysis() {
        return this.activeForAnalysis;
    }

    @Override
    public void setActiveForAnalysis(boolean activeForAnalysis) {
        this.activeForAnalysis = activeForAnalysis;
    }

    protected void validatePeakModel(IPeakModel peakModel) throws IllegalArgumentException {
        if (peakModel == null) {
            throw new IllegalArgumentException("The peak model must not be null");
        }
    }

    protected void validateChromatogram(IChromatogram chromatogram) throws IllegalArgumentException {
        if (chromatogram == null) {
            throw new IllegalArgumentException("The parent chromatogram must not be null");
        }
    }

    protected void validateRetentionTimes(IChromatogram chromatogram, IPeakModel peakModel) throws PeakException {
        int start = chromatogram.getStartRetentionTime();
        int stop = chromatogram.getStopRetentionTime();
        int startPeakModel = peakModel.getStartRetentionTime();
        int stopPeakModel = peakModel.getStopRetentionTime();
        if (startPeakModel < start || stopPeakModel > stop) {
            throw new PeakException("The start and stop retention times of the peak must be within the chromatogram retention time borders (" + startPeakModel + " >= " + start + " && " + stop + " <= " + stopPeakModel + ").");
        }
    }

    @Override
    public List<IInternalStandard> getInternalStandards() {
        return Collections.unmodifiableList(this.internalStandards);
    }

    @Override
    public void addInternalStandard(IInternalStandard internalStandard) {
        this.internalStandards.add(internalStandard);
    }

    @Override
    public void addInternalStandards(List<IInternalStandard> internalStandards) {
        this.internalStandards.addAll(internalStandards);
    }

    @Override
    public void removeInternalStandard(IInternalStandard internalStandard) {
        this.internalStandards.remove(internalStandard);
    }

    @Override
    public List<String> getQuantitationReferences() {
        return Collections.unmodifiableList(this.quantitationReferences);
    }

    @Override
    public void addQuantitationReference(String quantitationReference) {
        this.quantitationReferences.add(quantitationReference);
    }

    @Override
    public void addQuantitationReferences(List<String> quantitationReferences) {
        this.quantitationReferences.addAll(quantitationReferences);
    }

    @Override
    public void removeQuantitationReference(String quantitationReference) {
        this.quantitationReferences.remove(quantitationReference);
    }

    @Override
    public Set<IIdentificationTarget> getTargets() {
        return this.getPeakModel().getPeakMaximum().getTargets();
    }

    @Override
    public Collection<String> getClassifier() {
        return Collections.unmodifiableCollection(this.classifier);
    }

    @Override
    public void addClassifier(String classifier) {
        if (classifier != null && !classifier.trim().isEmpty()) {
            this.classifier.add(classifier.trim());
        }
    }

    @Override
    public void removeClassifier(String classifier) {
        this.classifier.remove(classifier);
    }

    public void setName(String name) {
        this.name = name != null && name.trim().isEmpty() ? null : name;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return this.name;
        }
        return IPeak.super.getName();
    }
}

