/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.exceptions.InvalidHeaderModificationException;
import org.eclipse.chemclipse.processing.ProcessorFactory;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.processing.filter.FilterContext;
import org.eclipse.chemclipse.processing.filter.Filtered;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class FilteredMeasurement<FilteredType extends IMeasurement, ConfigType>
implements IMeasurement,
Filtered<FilteredType, ConfigType> {
    private static final long serialVersionUID = 2L;
    private final FilteredType measurement;
    private String dataName;
    private String detailedInfo;
    private Double sampleWeight;
    private String sampleWeightUnit;
    private String barcodeType;
    private String barcode;
    private String sampleGroup;
    private String shortInfo;
    private String miscInfoSeparated;
    private String miscInfo;
    private Date date;
    private String operator;
    private final Map<String, IMeasurementResult<?>> measurementResults = new HashMap(1);
    private final Map<String, String> headerMap = new HashMap<String, String>(1);
    private transient FilterContext<FilteredType, ConfigType> context;

    public FilteredMeasurement(FilterContext<FilteredType, ConfigType> context) {
        this.context = context;
        if (context == null) {
            throw new IllegalArgumentException("filtered measurement can't be null!");
        }
        this.measurement = (IMeasurement)context.getFilteredObject();
    }

    public FilteredType getFilteredObject() {
        return this.measurement;
    }

    @Override
    public void addMeasurementResult(IMeasurementResult<?> measurementResult) {
        if (measurementResult != null) {
            this.measurementResults.put(measurementResult.getIdentifier(), measurementResult);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.measurement.getClass().isAssignableFrom(adapter)) {
            return adapter.cast(this.measurement);
        }
        return this.measurement.getAdapter(adapter);
    }

    public FilterContext<FilteredType, ConfigType> getFilterContext() {
        return this.context;
    }

    @Override
    public String getHeaderData(String key) {
        String value = this.headerMap.get(key);
        if (value != null) {
            return value;
        }
        return this.measurement.getHeaderData(key);
    }

    @Override
    public String getHeaderDataOrDefault(String key, String defaultValue) {
        String data = this.getHeaderData(key);
        if (data != null) {
            return data;
        }
        return defaultValue;
    }

    @Override
    public IMeasurementResult<?> getMeasurementResult(String identifier) {
        IMeasurementResult<?> result = this.measurementResults.get(identifier);
        if (result != null) {
            return result;
        }
        return this.measurement.getMeasurementResult(identifier);
    }

    @Override
    public boolean headerDataContainsKey(String key) {
        if (this.headerMap.containsKey(key)) {
            return true;
        }
        return this.measurement.headerDataContainsKey(key);
    }

    @Override
    public void putHeaderData(String key, String value) {
        this.headerMap.put(key, value);
    }

    @Override
    public void removeHeaderData(String key) throws InvalidHeaderModificationException {
        String remove = this.headerMap.remove(key);
        if (remove == null) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void deleteMeasurementResult(String identifier) {
        IMeasurementResult<?> remove = this.measurementResults.remove(identifier);
        if (remove == null) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Map<String, String> getHeaderDataMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.measurement.getHeaderDataMap());
        map.putAll(this.headerMap);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void removeAllMeasurementResults() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOperator() {
        if (this.operator != null) {
            return this.operator;
        }
        return this.measurement.getOperator();
    }

    @Override
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public Date getDate() {
        if (this.date != null) {
            return this.date;
        }
        return this.measurement.getDate();
    }

    @Override
    public Collection<IMeasurementResult<?>> getMeasurementResults() {
        ArrayList list = new ArrayList();
        list.addAll(this.measurementResults.values());
        list.addAll(this.measurement.getMeasurementResults());
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getMiscInfo() {
        if (this.miscInfo != null) {
            return this.miscInfo;
        }
        return this.measurement.getMiscInfo();
    }

    @Override
    public void setMiscInfo(String miscInfo) {
        this.miscInfo = miscInfo;
    }

    @Override
    public String getMiscInfoSeparated() {
        if (this.miscInfoSeparated != null) {
            return this.miscInfoSeparated;
        }
        return this.measurement.getMiscInfoSeparated();
    }

    @Override
    public void setMiscInfoSeparated(String miscInfoSeparated) {
        this.miscInfoSeparated = miscInfoSeparated;
    }

    @Override
    public String getShortInfo() {
        if (this.shortInfo != null) {
            return this.shortInfo;
        }
        return this.measurement.getShortInfo();
    }

    @Override
    public void setShortInfo(String shortInfo) {
        this.shortInfo = shortInfo;
    }

    @Override
    public String getDetailedInfo() {
        if (this.detailedInfo != null) {
            return this.detailedInfo;
        }
        return this.measurement.getDetailedInfo();
    }

    @Override
    public void setDetailedInfo(String detailedInfo) {
        this.detailedInfo = detailedInfo;
    }

    @Override
    public String getSampleGroup() {
        if (this.sampleGroup != null) {
            return this.sampleGroup;
        }
        return this.measurement.getSampleGroup();
    }

    @Override
    public void setSampleGroup(String sampleGroup) {
        this.sampleGroup = sampleGroup;
    }

    @Override
    public String getBarcode() {
        if (this.barcode != null) {
            return this.barcode;
        }
        return this.measurement.getBarcode();
    }

    @Override
    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    @Override
    public String getBarcodeType() {
        if (this.barcodeType != null) {
            return this.barcodeType;
        }
        return this.measurement.getBarcodeType();
    }

    @Override
    public void setBarcodeType(String barcodeType) {
        this.barcodeType = barcodeType;
    }

    @Override
    public double getSampleWeight() {
        if (this.sampleWeight != null) {
            return this.sampleWeight;
        }
        return this.measurement.getSampleWeight();
    }

    @Override
    public void setSampleWeight(double sampleWeight) {
        this.sampleWeight = sampleWeight;
    }

    @Override
    public String getSampleWeightUnit() {
        if (this.sampleWeightUnit != null) {
            return this.sampleWeightUnit;
        }
        return this.measurement.getSampleWeightUnit();
    }

    @Override
    public void setSampleWeightUnit(String sampleWeightUnit) {
        this.sampleWeightUnit = sampleWeightUnit;
    }

    @Override
    public String getDataName() {
        if (this.dataName != null) {
            return this.dataName;
        }
        return this.measurement.getDataName();
    }

    @Override
    public void setDataName(String dataName) {
        this.dataName = dataName;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.context.getFilterTime());
        out.writeObject(this.context.getFilteredObject());
        Object filterConfig = this.context.getFilterConfig();
        if (filterConfig instanceof Serializable) {
            out.writeObject(filterConfig);
        } else {
            out.writeObject(null);
        }
        Filter filter = this.context.getFilter();
        if (filter == null) {
            out.writeObject(null);
        } else {
            out.writeObject(filter.getID());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        final Date filterTime = (Date)in.readObject();
        final IMeasurement filteredObject = (IMeasurement)in.readObject();
        final Object filterConfig = in.readObject();
        final String filterID = (String)in.readObject();
        this.context = new FilterContext<FilteredType, ConfigType>(){
            private Filter<ConfigType> filter;

            public FilteredType getFilteredObject() {
                return filteredObject;
            }

            public Date getFilterTime() {
                return filterTime;
            }

            public Filter<ConfigType> getFilter() {
                ProcessorFactory service;
                ServiceReference reference;
                BundleContext bundleContext;
                if (this.filter == null && filterID != null && (bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext()) != null && (reference = bundleContext.getServiceReference(ProcessorFactory.class)) != null && (service = (ProcessorFactory)bundleContext.getService(reference)) != null) {
                    Collection filters = service.getProcessors(ProcessorFactory.genericClass(Filter.class), (filter, properties) -> filter.getID().equals(filterID));
                    Iterator iterator = filters.iterator();
                    while (iterator.hasNext()) {
                        Filter filter2;
                        this.filter = filter2 = (Filter)iterator.next();
                    }
                    bundleContext.ungetService(reference);
                }
                return this.filter;
            }

            public ConfigType getFilterConfig() {
                return filterConfig;
            }
        };
    }
}

