/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.filter;

import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.processing.filter.FilterList;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IChromatogramSelectionFilter<ConfigType>
extends Filter<ConfigType> {
    public IProcessingResult<Boolean> filterIChromatogramSelections(FilterList<IChromatogramSelection<?, ?>> var1, ConfigType var2, IProgressMonitor var3) throws IllegalArgumentException;

    public boolean acceptsIChromatogramSelection(IChromatogramSelection<?, ?> var1);

    default public ConfigType createConfiguration(IChromatogramSelection<?, ?> item) {
        return (ConfigType)this.createNewConfiguration();
    }

    public static <T extends IPeak> FilterList<IPeak> peakList(final IChromatogram<T> chromatogram, IChromatogramSelection<?, ?> selection) {
        final List peaks = selection == null ? chromatogram.getPeaks() : chromatogram.getPeaks(selection);
        return new FilterList<IPeak>(){

            public Iterator<IPeak> iterator() {
                return FilterList.convert(peaks.iterator());
            }

            public int size() {
                return peaks.size();
            }

            public <X extends IPeak> void remove(X item) {
                for (IPeak peak : peaks) {
                    if (peak != item) continue;
                    chromatogram.removePeak(peak);
                    return;
                }
            }
        };
    }

    public static FilterList<IScan> scanList(IChromatogram<?> chromatogram) {
        final List<IScan> scans = chromatogram.getScans();
        return new FilterList<IScan>(){

            public Iterator<IScan> iterator() {
                return FilterList.convert(scans.iterator());
            }

            public int size() {
                return scans.size();
            }
        };
    }

    default public Class<ConfigType> getConfigClass() {
        return null;
    }
}

