/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.identifier.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.model.identifier.core.ISupplier;
import org.eclipse.chemclipse.model.identifier.core.ISupport;

public abstract class AbstractSupport<S extends ISupplier>
implements ISupport {
    private final List<S> suppliers = new ArrayList<S>();

    public void add(S supplier) {
        this.suppliers.add(supplier);
    }

    private void areIdentifiersStored() throws NoIdentifierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoIdentifierAvailableException();
        }
    }

    @Override
    public List<String> getAvailableIdentifierIds() throws NoIdentifierAvailableException {
        this.areIdentifiersStored();
        ArrayList<String> availableIdentifiers = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            availableIdentifiers.add(supplier.getId());
        }
        if (availableIdentifiers.isEmpty()) {
            throw new NoIdentifierAvailableException("There is no appropriate identifier available.");
        }
        return availableIdentifiers;
    }

    @Override
    public String getIdentifierId(int index) throws NoIdentifierAvailableException {
        this.areIdentifiersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoIdentifierAvailableException("There is no identifier stored.");
        }
        ISupplier supplier = (ISupplier)this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getIdentifierNames() throws NoIdentifierAvailableException {
        this.areIdentifiersStored();
        ArrayList<String> identifierNames = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            identifierNames.add(supplier.getIdentifierName());
        }
        return identifierNames.toArray(new String[identifierNames.size()]);
    }

    protected S getSpecificIdentifierSupplier(String identifierId) throws NoIdentifierAvailableException {
        ISupplier identifierSupplier = null;
        this.areIdentifiersStored();
        if (identifierId == null || identifierId.equals("")) {
            throw new NoIdentifierAvailableException("There is no identifier supplier available with the following id: " + identifierId + ".");
        }
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(identifierId)) continue;
            identifierSupplier = supplier;
            break;
        }
        if (identifierSupplier == null) {
            throw new NoIdentifierAvailableException("There is no identifier supplier available with the following id: " + identifierId + ".");
        }
        return (S)identifierSupplier;
    }

    public Collection<S> getSuppliers() {
        return Collections.unmodifiableList(this.suppliers);
    }
}

