/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignals;
import org.eclipse.chemclipse.model.quantitation.IResponseSignals;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.model.quantitation.QuantitationSignal;
import org.eclipse.chemclipse.model.quantitation.QuantitationSignals;
import org.eclipse.chemclipse.model.quantitation.ResponseSignals;
import org.eclipse.chemclipse.model.quantitation.RetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.RetentionTimeWindow;

public abstract class AbstractQuantitationCompound
implements IQuantitationCompound {
    private static final long serialVersionUID = 1901297052527290065L;
    private String name = "";
    private String chemicalClass = "";
    private IRetentionTimeWindow retentionTimeWindow = new RetentionTimeWindow();
    private IRetentionIndexWindow retentionIndexWindow = new RetentionIndexWindow();
    private String concentrationUnit = "";
    private boolean useTIC = true;
    private CalibrationMethod calibrationMethod = CalibrationMethod.LINEAR;
    private boolean useCrossZero = true;
    private IQuantitationSignals quantitationSignals = new QuantitationSignals();
    private IResponseSignals responseSignals = new ResponseSignals();
    private List<IQuantitationPeak> quantitationPeaks = new ArrayList<IQuantitationPeak>();

    public AbstractQuantitationCompound(String name, String concentrationUnit) {
        this(name, concentrationUnit, 0);
    }

    public AbstractQuantitationCompound(String name, String concentrationUnit, int retentionTime) {
        this.name = name;
        this.concentrationUnit = concentrationUnit;
        this.retentionTimeWindow.setRetentionTime(retentionTime);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getChemicalClass() {
        return this.chemicalClass;
    }

    @Override
    public void setChemicalClass(String chemicalClass) {
        if (chemicalClass != null) {
            this.chemicalClass = chemicalClass;
        }
    }

    @Override
    public IRetentionTimeWindow getRetentionTimeWindow() {
        return this.retentionTimeWindow;
    }

    @Override
    public IRetentionIndexWindow getRetentionIndexWindow() {
        return this.retentionIndexWindow;
    }

    @Override
    public String getConcentrationUnit() {
        return this.concentrationUnit;
    }

    @Override
    public void setConcentrationUnit(String concentrationUnit) {
        this.concentrationUnit = concentrationUnit;
    }

    @Override
    public boolean isUseTIC() {
        return this.useTIC;
    }

    @Override
    public void setUseTIC(boolean useTIC) {
        this.useTIC = useTIC;
    }

    @Override
    public CalibrationMethod getCalibrationMethod() {
        return this.calibrationMethod;
    }

    @Override
    public void setCalibrationMethod(CalibrationMethod calibrationMethod) {
        this.calibrationMethod = calibrationMethod;
    }

    @Override
    public boolean isCrossZero() {
        return this.useCrossZero;
    }

    @Override
    public void setUseCrossZero(boolean useCrossZero) {
        this.useCrossZero = useCrossZero;
    }

    @Override
    public IQuantitationSignals getQuantitationSignals() {
        return this.quantitationSignals;
    }

    @Override
    public IResponseSignals getResponseSignals() {
        return this.responseSignals;
    }

    @Override
    public List<IQuantitationPeak> getQuantitationPeaks() {
        return this.quantitationPeaks;
    }

    @Override
    public void setQuantitationSignalTIC() {
        this.quantitationSignals.clear();
        this.quantitationSignals.add(new QuantitationSignal(0.0, 100.0, 0.0, true));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQuantitationCompound other = (AbstractQuantitationCompound)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "AbstractQuantitationCompound [name=" + this.name + ", chemicalClass=" + this.chemicalClass + ", concentrationUnit=" + this.concentrationUnit + ", useTIC=" + this.useTIC + ", calibrationMethod=" + (Object)((Object)this.calibrationMethod) + ", useCrossZero=" + this.useCrossZero + "]";
    }

    @Override
    public int compareTo(IQuantitationCompound quantitationCompound) {
        int result = 0;
        if (quantitationCompound != null) {
            result = this.getName().compareTo(quantitationCompound.getName());
        }
        return result;
    }
}

