/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import java.util.List;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class TargetTransferSupport {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String transferPeakTargets(List<? extends IPeak> peaksSource, List<? extends IPeak> peaksSink, int retentionTimeDelta, boolean useBestTargetOnly) {
        if (peaksSource.size() <= 0) return "The source chromatogram contains no peaks.";
        if (peaksSink.size() <= 0) return "The sink chromatogram contains no peaks.";
        TargetExtendedComparator comparator = new TargetExtendedComparator(SortOrder.DESC);
        for (IPeak iPeak : peaksSink) {
            for (IPeak iPeak2 : peaksSource) {
                int retentionTimePeakSource;
                int retentionTimePeakSink = iPeak.getPeakModel().getRetentionTimeAtPeakMaximum();
                if (!this.isPeakInFocus(retentionTimePeakSink, retentionTimePeakSource = iPeak2.getPeakModel().getRetentionTimeAtPeakMaximum(), retentionTimeDelta)) continue;
                if (useBestTargetOnly) {
                    IIdentificationTarget peakTarget = IIdentificationTarget.getBestIdentificationTarget(iPeak2.getTargets(), comparator);
                    this.transferPeakTarget(peakTarget, iPeak);
                    continue;
                }
                for (IIdentificationTarget peakTarget : iPeak2.getTargets()) {
                    this.transferPeakTarget(peakTarget, iPeak);
                }
            }
        }
        return null;
    }

    public String transferScanTargets(List<IScan> scansSource, IChromatogram chromatogramSink, boolean useBestTargetOnly) {
        if (scansSource.size() > 0) {
            TargetExtendedComparator comparator = new TargetExtendedComparator(SortOrder.DESC);
            for (IScan scanSource : scansSource) {
                IScan scanSink;
                int scanNumber = chromatogramSink.getScanNumber(scanSource.getRetentionTime());
                if (scanNumber <= 0 || (scanSink = chromatogramSink.getScan(scanNumber)) == null) continue;
                if (useBestTargetOnly) {
                    IIdentificationTarget peakTarget = IIdentificationTarget.getBestIdentificationTarget(scanSource.getTargets(), comparator);
                    this.transferScanTarget(peakTarget, scanSink);
                    continue;
                }
                for (IIdentificationTarget scanTarget : scanSource.getTargets()) {
                    this.transferScanTarget(scanTarget, scanSink);
                }
            }
        } else {
            return "The source chromatogram contains no identified scans.";
        }
        return null;
    }

    private boolean isPeakInFocus(int retentionTimePeakSink, int retentionTimePeakSource, int retentionTimeDelta) {
        return retentionTimePeakSink >= retentionTimePeakSource - retentionTimeDelta && retentionTimePeakSink <= retentionTimePeakSource + retentionTimeDelta;
    }

    private void transferPeakTarget(IIdentificationTarget identificationTargetSource, IPeak peakSink) {
        peakSink.getTargets().add(this.copyIdentificationTarget(identificationTargetSource));
    }

    private void transferScanTarget(IIdentificationTarget identificationTargetSource, IScan scanSink) {
        scanSink.getTargets().add(this.copyIdentificationTarget(identificationTargetSource));
    }

    private IIdentificationTarget copyIdentificationTarget(IIdentificationTarget identificationTargetSource) {
        LibraryInformation libraryInformation = new LibraryInformation(identificationTargetSource.getLibraryInformation());
        ComparisonResult comparisonResult = new ComparisonResult(identificationTargetSource.getComparisonResult());
        return new IdentificationTarget(libraryInformation, comparisonResult);
    }
}

