/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.io.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.csv.model.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.csv.model.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.csv.model.VendorScan;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader
extends AbstractChromatogramMSDReader
implements IChromatogramMSDReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader.class);
    private static final String ZERO_VALUE = "0.0";
    private static final int Ion_COLUMN_START = 3;

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        if (ChromatogramReader.isValidFileFormat(file)) {
            return this.readChromatogram(file, false);
        }
        return null;
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        if (ChromatogramReader.isValidFileFormat(file)) {
            return this.readChromatogram(file, true);
        }
        return null;
    }

    public static boolean isValidFileFormat(File file) throws IOException {
        FileReader reader = new FileReader(file);
        char[] chars = new char["RT(milliseconds)".length()];
        reader.read(chars);
        reader.close();
        String firstColumn = new String(chars);
        return firstColumn.equals("RT(milliseconds)");
    }

    private IChromatogramMSD readChromatogram(File file, boolean overview) throws IOException {
        VendorChromatogram chromatogram = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileReader reader = new FileReader(file);){
            CSVParser parser = new CSVParser((Reader)reader, CSVFormat.EXCEL.withHeader(new String[0]));
            chromatogram = new VendorChromatogram();
            if (!overview) {
                chromatogram.setConverterId("");
                chromatogram.setFile(file);
            }
            Map<Integer, Float> ionsMap = this.getIonMap(parser);
            for (CSVRecord record : parser.getRecords()) {
                IVendorMassSpectrum supplierMassSpectrum = this.getScan(record, ionsMap, overview);
                chromatogram.addScan((IScan)supplierMassSpectrum);
            }
            int scanDelay = chromatogram.getScan(1).getRetentionTime();
            chromatogram.setScanDelay(scanDelay);
            parser.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return chromatogram;
    }

    private Map<Integer, Float> getIonMap(CSVParser parser) {
        HashMap<Integer, Float> ions = new HashMap<Integer, Float>();
        Map headerMap = parser.getHeaderMap();
        for (Map.Entry entry : headerMap.entrySet()) {
            int index = (Integer)entry.getValue();
            try {
                ions.put(index, Float.valueOf((String)entry.getKey()));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
        }
        return ions;
    }

    private IVendorMassSpectrum getScan(CSVRecord csvRecord, Map<Integer, Float> ionsMap, boolean overview) {
        VendorScan massSpectrum = new VendorScan();
        String retentionTimeInMilliseconds = csvRecord.get(0);
        int retentionTime = Integer.valueOf(retentionTimeInMilliseconds);
        massSpectrum.setRetentionTime(retentionTime);
        String retentionIndexValue = csvRecord.get(2);
        float retentionIndex = Float.valueOf(retentionIndexValue).floatValue();
        massSpectrum.setRetentionIndex(retentionIndex);
        if (overview) {
            try {
                IIon ion = this.getIonsOverview(csvRecord);
                massSpectrum.addIon(ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        } else {
            List<IIon> ions = this.getIons(csvRecord, ionsMap);
            for (IIon ion : ions) {
                massSpectrum.addIon(ion);
            }
        }
        return massSpectrum;
    }

    private IIon getIonsOverview(CSVRecord csvRecord) throws AbundanceLimitExceededException, IonLimitExceededException {
        float abundanceTotalSignal = 0.0f;
        int index = 3;
        while (index < csvRecord.size()) {
            String abundanceValue = csvRecord.get(index);
            if (!abundanceValue.equals(ZERO_VALUE)) {
                float abundance = Float.valueOf(abundanceValue).floatValue();
                abundanceTotalSignal += abundance;
            }
            ++index;
        }
        VendorIon ion = new VendorIon(0.0, abundanceTotalSignal);
        return ion;
    }

    private List<IIon> getIons(CSVRecord csvRecord, Map<Integer, Float> ionsMap) {
        ArrayList<IIon> ions = new ArrayList<IIon>();
        int index = 3;
        while (index < csvRecord.size()) {
            String abundanceValue = csvRecord.get(index);
            if (!abundanceValue.equals(ZERO_VALUE)) {
                float abundance = Float.valueOf(abundanceValue).floatValue();
                float ion = ionsMap.get(index).floatValue();
                try {
                    VendorIon csvIon = new VendorIon((double)ion, abundance);
                    ions.add((IIon)csvIon);
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
            }
            ++index;
        }
        return ions;
    }
}

