/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.excel.internal.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.poi.ss.util.CellReference;

public class SpreadsheetWriter {
    private final Writer writer;
    private int rowNumber;
    private String xmlEncoding;

    public SpreadsheetWriter(Writer writer, String xmlEncoding) {
        this.writer = writer;
        this.xmlEncoding = xmlEncoding;
    }

    public void beginSheet() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>" + "<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
        this.writer.write("<sheetData>\n");
    }

    public void endSheet() throws IOException {
        this.writer.write("</sheetData>");
        this.writer.write("</worksheet>");
    }

    public void insertRow(int rowNumber) throws IOException {
        this.writer.write("<row r=\"" + (rowNumber + 1) + "\">\n");
        this.rowNumber = rowNumber;
    }

    public void endRow() throws IOException {
        this.writer.write("</row>\n");
    }

    public void createCell(int columnNumber, String value, int styleIndex) throws IOException {
        String ref = new CellReference(this.rowNumber, columnNumber).formatAsString();
        this.writer.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
        if (styleIndex != -1) {
            this.writer.write(" s=\"" + styleIndex + "\"");
        }
        this.writer.write(">");
        this.writer.write("<is><t>" + value + "</t></is>");
        this.writer.write("</c>");
    }

    public void createCell(int columnIndex, String value) throws IOException {
        this.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnNumber, double value, int styleIndex) throws IOException {
        String ref = new CellReference(this.rowNumber, columnNumber).formatAsString();
        this.writer.write("<c r=\"" + ref + "\" t=\"n\"");
        if (styleIndex != -1) {
            this.writer.write(" s=\"" + styleIndex + "\"");
        }
        this.writer.write(">");
        this.writer.write("<v>" + value + "</v>");
        this.writer.write("</c>");
    }

    public void createCell(int columnNumber, double value) throws IOException {
        this.createCell(columnNumber, value, -1);
    }
}

