/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.io.AbstractReaderVersion;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.v32.model.MsRun;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.v32.model.Peaks;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.v32.model.Scan;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorScan;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReaderVersion32
extends AbstractReaderVersion
implements IChromatogramMSDReader {
    private static final Logger logger = Logger.getLogger(ReaderVersion32.class);
    private static final int ION_PRECISION = 4;
    private String contextPath;

    public ReaderVersion32(String contextPath) {
        this.contextPath = contextPath;
    }

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        VendorChromatogram chromatogram = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("msRun");
            JAXBContext jaxbContext = JAXBContext.newInstance((String)this.contextPath);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            MsRun msrun = (MsRun)unmarshaller.unmarshal(nodeList.item(0));
            chromatogram = new VendorChromatogram();
            boolean isTandemMeasurement = this.isTandemMeasurement(msrun);
            int cycleNumber = isTandemMeasurement ? 1 : 0;
            for (Scan scan : msrun.getScan()) {
                VendorScan massSpectrum = new VendorScan();
                int retentionTime = scan.getRetentionTime().multiply(1000).getSeconds();
                short msLevel = scan.getMsLevel().shortValue();
                massSpectrum.setMassSpectrometer(msLevel);
                if (msLevel < 2) {
                    ++cycleNumber;
                }
                if (cycleNumber >= 1) {
                    massSpectrum.setCycleNumber(cycleNumber);
                }
                massSpectrum.setRetentionTime(retentionTime);
                for (Peaks peaks : scan.getPeaks()) {
                    int index;
                    double[] values;
                    String byteOrder;
                    ByteBuffer byteBuffer = ByteBuffer.wrap(peaks.getValue());
                    String compressionType = peaks.getCompressionType();
                    if (compressionType != null && compressionType.toLowerCase().equals("zlib")) {
                        Inflater inflater = new Inflater();
                        inflater.setInput(byteBuffer.array());
                        byte[] byteArray = new byte[byteBuffer.capacity() * 10];
                        byteBuffer = ByteBuffer.wrap(byteArray, 0, inflater.inflate(byteArray));
                    }
                    if ((byteOrder = peaks.getByteOrder()) != null && byteOrder.equals("network")) {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                    } else {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    BigInteger precision = peaks.getPrecision();
                    if (precision != null && precision.intValue() == 64) {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        values = new double[doubleBuffer.capacity()];
                        index = 0;
                        while (index < doubleBuffer.capacity()) {
                            values[index] = new Double(doubleBuffer.get(index));
                            ++index;
                        }
                    } else {
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        values = new double[floatBuffer.capacity()];
                        index = 0;
                        while (index < floatBuffer.capacity()) {
                            values[index] = new Double(floatBuffer.get(index));
                            ++index;
                        }
                    }
                    int peakIndex = 0;
                    while (peakIndex < values.length - 1) {
                        double mz = AbstractIon.getIon((double)values[peakIndex], (int)4);
                        float intensity = (float)values[peakIndex + 1];
                        try {
                            if (intensity >= Float.MIN_VALUE && intensity <= Float.MAX_VALUE) {
                                massSpectrum.addIon((IIon)new VendorIon(mz, intensity));
                            }
                        }
                        catch (AbundanceLimitExceededException e) {
                            logger.warn((Object)e);
                        }
                        catch (IonLimitExceededException e) {
                            logger.warn((Object)e);
                        }
                        peakIndex += 2;
                    }
                }
                chromatogram.addScan((IScan)massSpectrum);
            }
        }
        catch (SAXException e) {
            logger.warn((Object)e);
        }
        catch (JAXBException e) {
            logger.warn((Object)e);
        }
        catch (ParserConfigurationException e) {
            logger.warn((Object)e);
        }
        catch (DataFormatException e) {
            logger.warn((Object)e);
        }
        chromatogram.setConverterId("");
        chromatogram.setFile(file);
        return chromatogram;
    }

    private boolean isTandemMeasurement(MsRun msrun) {
        for (Scan scan : msrun.getScan()) {
            if (scan.getMsLevel().shortValue() <= 1) continue;
            return true;
        }
        return false;
    }
}

