/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.openchromx.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.filter.IdentifierEventFilter;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.filter.SupplierIonsEventFilter;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.filter.SupplierMassSpectrumEventFilter;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.support.DateSupport;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.support.IonSupport;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.model.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.model.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.model.VendorScan;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.support.history.EditInformation;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader
extends AbstractChromatogramMSDReader
implements IChromatogramMSDReader {
    private static Logger logger = Logger.getLogger(ChromatogramReader.class);
    public static final String VALID_FILE_FORMAT_CHECK = "ChemClipseChromatogram";

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        VendorChromatogram chromatogram = new VendorChromatogram();
        try {
            monitor.subTask("Import Chromatogram");
            this.isValidFileFormat(file);
            this.readHeader(file, chromatogram);
            this.readMassSpectra(file, chromatogram, false, monitor);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return chromatogram;
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        VendorChromatogram chromatogram = new VendorChromatogram();
        try {
            monitor.subTask("Import Chromatogram Overview");
            this.isValidFileFormat(file);
            this.readHeader(file, chromatogram);
            this.readMassSpectra(file, chromatogram, true, monitor);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return chromatogram;
    }

    private void readHeader(File file, IChromatogramMSD chromatogram) throws XMLStreamException, IOException {
        XMLInputFactory.newInstance().setProperty("javax.xml.stream.isCoalescing", true);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        while (eventReader.hasNext()) {
            String elementName;
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                elementName = event.asStartElement().getName().getLocalPart();
                if (elementName.equals("Operator")) {
                    this.addOperator(chromatogram, event, eventReader);
                    continue;
                }
                if (elementName.equals("Date")) {
                    this.addDate(chromatogram, event, eventReader);
                    continue;
                }
                if (elementName.equals("MiscInfo")) {
                    this.addMiscInfo(chromatogram, event, eventReader);
                    continue;
                }
                if (!elementName.equals("EditInformation")) continue;
                this.addEditInformation(chromatogram, event, eventReader);
                continue;
            }
            if (event.isEndElement() && (elementName = event.asEndElement().getName().getLocalPart()).equals("Header")) break;
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void addOperator(IChromatogramMSD chromatogram, XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        event = eventReader.nextEvent();
        chromatogram.setOperator(event.asCharacters().getData());
    }

    private void addDate(IChromatogramMSD chromatogram, XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        Date date;
        event = eventReader.nextEvent();
        try {
            date = DateSupport.getDate(event.asCharacters().getData());
        }
        catch (ParseException e) {
            date = new Date();
        }
        chromatogram.setDate(date);
    }

    private void addMiscInfo(IChromatogramMSD chromatogram, XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        event = eventReader.nextEvent();
        chromatogram.setMiscInfo(event.asCharacters().getData());
    }

    private void addEditInformation(IChromatogramMSD chromatogram, XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        Date date;
        Attribute dateAttribute = event.asStartElement().getAttributeByName(new QName("date"));
        try {
            date = DateSupport.getDate(dateAttribute.getValue());
        }
        catch (ParseException e) {
            date = new Date();
        }
        event = eventReader.nextEvent();
        String description = event.asCharacters().getData();
        EditInformation editInformation = new EditInformation(date, description);
        chromatogram.getEditHistory().add((Object)editInformation);
    }

    private void readMassSpectra(File file, IChromatogramMSD chromatogram, boolean overview, IProgressMonitor monitor) throws XMLStreamException, IOException {
        monitor.subTask("Parse Scans");
        int scan = 1;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        int retentionTime = 0;
        float retentionIndex = 0.0f;
        float totalSignal = 0.0f;
        SupplierMassSpectrumEventFilter eventFilter = new SupplierMassSpectrumEventFilter();
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            monitor.subTask("Scan " + scan++);
            VendorScan supplierMassSpectrum = new VendorScan();
            Iterator<Attribute> attributes = event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String attributeName = attribute.getName().getLocalPart();
                if (attributeName.equals("retentionTime")) {
                    retentionTime = Integer.valueOf(attribute.getValue());
                }
                if (attributeName.equals("retentionIndex")) {
                    retentionIndex = Float.valueOf(attribute.getValue()).floatValue();
                }
                if (!attributeName.equals("totalSignal")) continue;
                totalSignal = Float.valueOf(attribute.getValue()).floatValue();
            }
            supplierMassSpectrum.setRetentionTime(retentionTime);
            supplierMassSpectrum.setRetentionIndex(retentionIndex);
            if (overview) {
                this.addTotalSignal(supplierMassSpectrum, totalSignal);
            } else {
                this.readIons(inputFactory, eventReader, supplierMassSpectrum);
            }
            chromatogram.addScan((IScan)supplierMassSpectrum);
        }
        eventReader.close();
        bufferedInputStream.close();
        int scanInterval = chromatogram.getStopRetentionTime() / chromatogram.getNumberOfScans();
        int scanDelay = chromatogram.getStartRetentionTime() - scanInterval;
        scanDelay = scanDelay < 0 ? 0 : scanDelay;
        chromatogram.setScanInterval(scanInterval);
        chromatogram.setScanDelay(scanDelay);
        chromatogram.setConverterId("org.eclipse.chemclipse.msd.converter.supplier.openchromx");
    }

    private void addTotalSignal(IVendorMassSpectrum supplierMassSpectrum, float totalSignal) {
        try {
            VendorIon ion = new VendorIon(0.0, totalSignal);
            supplierMassSpectrum.addIon((IIon)ion);
        }
        catch (AbundanceLimitExceededException e) {
            logger.warn((Object)e);
        }
        catch (IonLimitExceededException e) {
            logger.warn((Object)e);
        }
    }

    private void readIons(XMLInputFactory inputFactory, XMLEventReader eventReader, IVendorMassSpectrum supplierMassSpectrum) throws XMLStreamException {
        SupplierIonsEventFilter eventFilter = new SupplierIonsEventFilter();
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        if (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            event = eventReader.nextEvent();
            String encodedIons = event.asCharacters().getData();
            IonSupport.decodeIons(supplierMassSpectrum, encodedIons);
        }
    }

    private boolean isValidFileFormat(File file) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        boolean result = false;
        IdentifierEventFilter eventFilter = new IdentifierEventFilter();
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        if (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            event = eventReader.nextEvent();
            String description = event.asCharacters().getData();
            if (description.equals(VALID_FILE_FORMAT_CHECK)) {
                result = true;
            }
        }
        eventReader.close();
        bufferedInputStream.close();
        return result;
    }
}

