/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.openchromx.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.support.DateSupport;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.support.IonSupport;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramWriter
implements IChromatogramMSDWriter {
    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            XMLEventWriter eventWriter = xmlOutputFactory.createXMLEventWriter(bufferedOutputStream, "UTF-8");
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            eventWriter.add(eventFactory.createStartDocument());
            StartElement chromatogramStart = eventFactory.createStartElement("", "", "Chromatogram");
            eventWriter.add(chromatogramStart);
            this.writeChromatogramIdentifier(eventWriter, eventFactory);
            this.writeChromatogramHeader(eventWriter, eventFactory, chromatogram);
            Comment massSpectraInfo = eventFactory.createComment("The retention time is given in milliseconds. All ions are encoded with the Base64 algorithm. It's structure is ion-abundance ion-abundance ...");
            eventWriter.add(massSpectraInfo);
            monitor.subTask("Export Chromatogram");
            this.writeChromatogramMassSpectra(eventWriter, eventFactory, chromatogram, monitor);
            EndElement chromatogramEnd = eventFactory.createEndElement("", "", "Chromatogram");
            eventWriter.add(chromatogramEnd);
            eventWriter.add(eventFactory.createEndDocument());
            bufferedOutputStream.flush();
            eventWriter.flush();
            bufferedOutputStream.close();
            eventWriter.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeChromatogramIdentifier(XMLEventWriter eventWriter, XMLEventFactory eventFactory) throws XMLStreamException {
        StartElement chromatogramIdentifierStart = eventFactory.createStartElement("", "", "Identifier");
        EndElement chromatogramIdentifierEnd = eventFactory.createEndElement("", "", "Identifier");
        Characters chromatogramIdentifierId = eventFactory.createCharacters("ChemClipseChromatogram");
        eventWriter.add(chromatogramIdentifierStart);
        eventWriter.add(chromatogramIdentifierId);
        eventWriter.add(chromatogramIdentifierEnd);
    }

    private void writeChromatogramHeader(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram) throws XMLStreamException {
        StartElement headerStart = eventFactory.createStartElement("", "", "Header");
        EndElement headerEnd = eventFactory.createEndElement("", "", "Header");
        eventWriter.add(headerStart);
        this.writeOperator(eventWriter, eventFactory, chromatogram);
        this.writeDate(eventWriter, eventFactory, chromatogram);
        this.writeMiscInfo(eventWriter, eventFactory, chromatogram);
        IEditHistory editHistory = chromatogram.getEditHistory();
        this.writeEditHistory(eventWriter, eventFactory, editHistory);
        eventWriter.add(headerEnd);
    }

    private void writeOperator(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram) throws XMLStreamException {
        StartElement operatorStart = eventFactory.createStartElement("", "", "Operator");
        EndElement operatorEnd = eventFactory.createEndElement("", "", "Operator");
        Characters operator = eventFactory.createCData(chromatogram.getOperator());
        eventWriter.add(operatorStart);
        eventWriter.add(operator);
        eventWriter.add(operatorEnd);
    }

    private void writeDate(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram) throws XMLStreamException {
        StartElement dateStart = eventFactory.createStartElement("", "", "Date");
        EndElement dateEnd = eventFactory.createEndElement("", "", "Date");
        Characters date = eventFactory.createCharacters(DateSupport.getDate(chromatogram.getDate()));
        eventWriter.add(dateStart);
        eventWriter.add(date);
        eventWriter.add(dateEnd);
    }

    private void writeMiscInfo(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram) throws XMLStreamException {
        StartElement miscInfoStart = eventFactory.createStartElement("", "", "MiscInfo");
        EndElement miscInfoEnd = eventFactory.createEndElement("", "", "MiscInfo");
        Characters miscInfo = eventFactory.createCData(chromatogram.getMiscInfo());
        eventWriter.add(miscInfoStart);
        eventWriter.add(miscInfo);
        eventWriter.add(miscInfoEnd);
    }

    private void writeEditHistory(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IEditHistory editHistory) throws XMLStreamException {
        StartElement editHistoryStart = eventFactory.createStartElement("", "", "EditHistory");
        EndElement editHistoryEnd = eventFactory.createEndElement("", "", "EditHistory");
        StartElement editInformationStart = eventFactory.createStartElement("", "", "EditInformation");
        EndElement editInformationEnd = eventFactory.createEndElement("", "", "EditInformation");
        eventWriter.add(editHistoryStart);
        for (IEditInformation editInformation : editHistory) {
            Attribute editDate = eventFactory.createAttribute("date", editInformation.getDate().toString());
            Characters description = eventFactory.createCData(editInformation.getDescription());
            eventWriter.add(editInformationStart);
            eventWriter.add(editDate);
            eventWriter.add(description);
            eventWriter.add(editInformationEnd);
        }
        eventWriter.add(editHistoryEnd);
    }

    private void writeChromatogramMassSpectra(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws XMLStreamException {
        monitor.subTask("Export Scans");
        StartElement scansStart = eventFactory.createStartElement("", "", "Scans");
        EndElement scansEnd = eventFactory.createEndElement("", "", "Scans");
        eventWriter.add(scansStart);
        int scan = 1;
        while (scan <= chromatogram.getNumberOfScans()) {
            monitor.subTask("Scan " + scan);
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            this.writeChromatogramMassSpectrum(eventWriter, eventFactory, massSpectrum);
            ++scan;
        }
        eventWriter.add(scansEnd);
    }

    private void writeChromatogramMassSpectrum(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IVendorMassSpectrum massSpectrum) throws XMLStreamException {
        StartElement supplierMassSpectrumStart = eventFactory.createStartElement("", "", "SupplierMassSpectrum");
        EndElement supplierMassSpectrumEnd = eventFactory.createEndElement("", "", "SupplierMassSpectrum");
        Attribute retentionTime = eventFactory.createAttribute("retentionTime", Integer.valueOf(massSpectrum.getRetentionTime()).toString());
        Attribute retentionIndex = eventFactory.createAttribute("retentionIndex", Float.valueOf(massSpectrum.getRetentionIndex()).toString());
        Attribute totalIonSignal = eventFactory.createAttribute("totalSignal", Float.valueOf(massSpectrum.getTotalSignal()).toString());
        StartElement supplierIonsStart = eventFactory.createStartElement("", "", "SupplierMassFragments");
        EndElement supplierIonsEnd = eventFactory.createEndElement("", "", "SupplierMassFragments");
        eventWriter.add(supplierMassSpectrumStart);
        eventWriter.add(retentionTime);
        eventWriter.add(retentionIndex);
        eventWriter.add(totalIonSignal);
        eventWriter.add(supplierIonsStart);
        Characters ions = eventFactory.createCharacters(IonSupport.encodeIons(massSpectrum));
        eventWriter.add(ions);
        eventWriter.add(supplierIonsEnd);
        eventWriter.add(supplierMassSpectrumEnd);
    }
}

