/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.preferences;

import java.io.File;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class NistApplicationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private DirectoryFieldEditor pathEditor;

    public NistApplicationPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, PreferenceSupplier.INSTANCE().getPreferenceNode()));
        this.setTitle("NIST Database Integration");
        this.setDescription("Here you can configure the location of the NIST-Database Application that should be used by NIST integration modules");
        this.noDefaultButton();
    }

    public void createFieldEditors() {
        this.pathEditor = new DirectoryFieldEditor("nistApplication", "Nist installation path", this.getFieldEditorParent()){

            protected boolean doCheckState() {
                File location;
                IStatus status;
                String value = NistApplicationPreferencePage.this.pathEditor.getStringValue();
                if (!value.isEmpty() && !(status = PreferenceSupplier.validateLocation((File)(location = new File(value)))).isOK()) {
                    this.setErrorMessage(status.getMessage());
                    return false;
                }
                return super.doCheckState();
            }
        };
        this.pathEditor.setEmptyStringAllowed(true);
        this.addField((FieldEditor)this.pathEditor);
        if (OperatingSystemUtils.isMac()) {
            this.addField((FieldEditor)new StringFieldEditor("macWineBinary", "Wine binary (/Applications/Wine.app)", this.getFieldEditorParent()));
        }
    }

    public void init(IWorkbench workbench) {
    }
}

