/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.msd.model.core.comparator.IonComparatorMode;
import org.eclipse.chemclipse.msd.model.core.comparator.IonValueComparator;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class IonCombinedComparator
implements Comparator<IIon>,
Serializable {
    private static final long serialVersionUID = -109573471700765379L;
    private final Comparator<IIon> firstComparator;
    private final Comparator<IIon> secondComparator;

    public IonCombinedComparator(IonComparatorMode ionComparatorMode) {
        this(ionComparatorMode, SortOrder.ASC);
    }

    public IonCombinedComparator(IonComparatorMode ionComparatorMode, SortOrder sortOrder) {
        switch (ionComparatorMode) {
            case ABUNDANCE_FIRST: {
                this.firstComparator = new IonAbundanceComparator(sortOrder);
                this.secondComparator = new IonValueComparator(sortOrder);
                break;
            }
            case MZ_FIRST: {
                this.firstComparator = new IonValueComparator(sortOrder);
                this.secondComparator = new IonAbundanceComparator(sortOrder);
                break;
            }
            default: {
                this.firstComparator = new IonAbundanceComparator(sortOrder);
                this.secondComparator = new IonValueComparator(sortOrder);
            }
        }
    }

    @Override
    public int compare(IIon ion1, IIon ion2) {
        int result = this.firstComparator.compare(ion1, ion2);
        if (result != 0) {
            return result;
        }
        result = this.secondComparator.compare(ion1, ion2);
        return result;
    }
}

