/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.nmr.model.core;

import java.math.BigDecimal;

public interface AcquisitionParameter {
    public static final int MIN_DIGITS = 10;

    public BigDecimal getSpectralWidth();

    default public BigDecimal getAcquisitionTime() {
        return BigDecimal.valueOf(this.getNumberOfPoints()).divide(this.getSpectralWidth().multiply(this.getCarrierFrequency()), 10, 6);
    }

    public int getNumberOfPoints();

    public BigDecimal getSpectrometerFrequency();

    public BigDecimal getCarrierFrequency();

    default public BigDecimal getSpectralOffset() {
        BigDecimal sfo1 = this.getCarrierFrequency();
        BigDecimal sf = this.getSpectrometerFrequency();
        BigDecimal sw = this.getSpectralWidth();
        BigDecimal multiplicand = new BigDecimal("0.5");
        BigDecimal fac1 = sfo1.divide(sf.subtract(BigDecimal.ONE), 10, 6);
        BigDecimal halfWidthPPM = sw.multiply(multiplicand);
        BigDecimal fac2 = sfo1.divide(sf, 10, 6);
        return this.toHz(fac1.multiply(new BigDecimal("1E6")).add(this.toHz(halfWidthPPM)).multiply(fac2));
    }

    default public BigDecimal toHz(BigDecimal ppm) {
        return ppm.multiply(this.getCarrierFrequency());
    }

    default public BigDecimal toPPM(BigDecimal hz) {
        BigDecimal cf = this.getCarrierFrequency();
        return hz.divide(cf, Math.max(10, Math.max(hz.scale(), cf.scale())), 6);
    }

    public static void print(AcquisitionParameter acquisitionParameter) {
        System.out.println("CarrierFrequency:      " + acquisitionParameter.getCarrierFrequency());
        System.out.println("NumberOfPoints:        " + acquisitionParameter.getNumberOfPoints());
        System.out.println("SpectralOffset:        " + acquisitionParameter.getSpectralOffset());
        System.out.println("SpectralWidth:         " + acquisitionParameter.getSpectralWidth());
        System.out.println("SpectrometerFrequency: " + acquisitionParameter.getSpectrometerFrequency());
        System.out.println("AcquisitionTime:       " + acquisitionParameter.getAcquisitionTime());
    }
}

