/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.core;

import java.util.Date;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;

public abstract class AbstractProcessingMessage
implements IProcessingMessage {
    private MessageType messageType = MessageType.ERROR;
    private Date date = new Date();
    private String description = "Description was null.";
    private String message = "Message was null.";
    private String proposedSolution = "";
    private String details;

    public AbstractProcessingMessage(MessageType messageType, String description, String message) {
        this(messageType, description, message, "");
    }

    public AbstractProcessingMessage(MessageType messageType, String description, String message, String proposedSolution) {
        if (messageType != null) {
            this.messageType = messageType;
        }
        if (description != null) {
            this.description = description;
        }
        if (message != null) {
            this.message = message;
        }
        if (proposedSolution != null) {
            this.proposedSolution = proposedSolution;
        }
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setProposedSolution(String proposedSolution) {
        this.proposedSolution = proposedSolution;
    }

    @Override
    public String getProposedSolution() {
        return this.proposedSolution;
    }

    @Override
    public Throwable getException() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("date=" + this.date);
        builder.append(",");
        builder.append("messageType=" + (Object)((Object)this.messageType));
        builder.append(",");
        builder.append("description=" + this.description);
        builder.append(",");
        builder.append("message=" + this.message);
        builder.append(",");
        builder.append("proposedSolution=" + this.proposedSolution);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }
}

