/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.internal;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ProcessSupplierContext.class})
public class OSGiProcessSupplierContext
implements ProcessSupplierContext {
    private final ConcurrentMap<String, IProcessSupplier<?>> supplierMap = new ConcurrentHashMap();
    private final Set<IProcessTypeSupplier> typeSupplierSet = new ConcurrentHashMap().keySet(Boolean.TRUE);

    @Override
    public <T> IProcessSupplier<T> getSupplier(String id) {
        IProcessSupplier mappedSupplier = (IProcessSupplier)this.supplierMap.get(id);
        if (mappedSupplier != null) {
            return mappedSupplier;
        }
        for (IProcessTypeSupplier typeSupplier : this.typeSupplierSet) {
            IProcessSupplier supplier = typeSupplier.getSupplier(id);
            if (supplier == null) continue;
            return supplier;
        }
        return null;
    }

    @Override
    public void visitSupplier(Consumer<? super IProcessSupplier<?>> consumer) {
        this.supplierMap.values().forEach(consumer);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addProcessTypeSupplier(IProcessTypeSupplier typeSupplier) {
        this.typeSupplierSet.add(typeSupplier);
        for (IProcessSupplier<?> supplier : typeSupplier.getProcessorSuppliers()) {
            IProcessSupplier<?> old = this.supplierMap.putIfAbsent(supplier.getId(), supplier);
            if (old == null) continue;
            throw new IllegalArgumentException("There is a duplicate mapping for id " + supplier.getId());
        }
    }

    public void removeProcessTypeSupplier(IProcessTypeSupplier typeSupplier) {
        this.typeSupplierSet.remove(typeSupplier);
        for (IProcessSupplier<?> supplier : typeSupplier.getProcessorSuppliers()) {
            this.supplierMap.remove(supplier.getId());
        }
    }
}

