/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.provider;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PerspectiveSwitcherViewerFilter
extends ViewerFilter {
    private static final Logger logger = Logger.getLogger(PerspectiveSwitcherViewerFilter.class);
    private String searchPattern;
    private boolean caseInsensitive;

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = this.caseInsensitive ? searchPattern.toLowerCase() : searchPattern;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchPattern == null || this.searchPattern.equals("")) {
            return true;
        }
        if (element instanceof MPerspective) {
            MPerspective perspective = (MPerspective)element;
            String perspectiveLabel = perspective.getLabel();
            if (perspectiveLabel != null) {
                String label;
                String string = label = this.caseInsensitive ? perspectiveLabel.toLowerCase() : perspectiveLabel;
                if (label.contains(this.searchPattern)) {
                    return true;
                }
            } else {
                logger.warn((Object)("Please add a perspective label: " + perspective.getElementId()));
            }
        }
        return false;
    }
}

