/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.files;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSpecificationValidator {
    private static final Logger logger = LoggerFactory.getLogger(FileSpecificationValidator.class);

    public File validate(File file, String directoryExtension) {
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            this.validateAndPatchDirectory(file, directoryExtension);
        }
        return file;
    }

    public File validateAndPatchDirectory(File file, String directoryExtension) {
        String fileName = file.getName().toLowerCase();
        if (!fileName.endsWith(directoryExtension = directoryExtension.toLowerCase()) && !(file = new File(String.valueOf(file.getAbsolutePath()) + directoryExtension)).mkdir()) {
            logger.info("The directory already exists: " + file.getAbsolutePath());
        }
        return file;
    }
}

