/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.settings.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.chemclipse.support.settings.parser.InputValue;
import org.eclipse.chemclipse.support.settings.serialization.SettingsSerialization;

public class JSONSerialization
implements SettingsSerialization {
    private static final Map<Class<?>, Class<?>> MAPPINGS = new ConcurrentHashMap();
    private static final SimpleAbstractTypeResolver RESOLVER = new SimpleAbstractTypeResolver(){
        private static final long serialVersionUID = 1L;

        public JavaType findTypeMapping(DeserializationConfig config, JavaType type) {
            Class src = type.getRawClass();
            Class dst = (Class)MAPPINGS.get(src);
            if (dst == null) {
                return null;
            }
            return config.getTypeFactory().constructSpecializedType(type, dst);
        }
    };

    @Override
    public Map<InputValue, Object> fromString(Collection<? extends InputValue> inputValues, String content) throws IOException {
        LinkedHashMap<InputValue, Object> result = new LinkedHashMap<InputValue, Object>();
        for (InputValue inputValue : inputValues) {
            result.put(inputValue, inputValue.getDefaultValue());
        }
        if (content != null && !content.isEmpty()) {
            Map map = (Map)this.createMapper().readValue(content, HashMap.class);
            for (Map.Entry entry : map.entrySet()) {
                for (InputValue inputValue : inputValues) {
                    Object value;
                    if (!inputValue.getName().equals(entry.getKey()) || (value = entry.getValue()) == null) continue;
                    result.put(inputValue, value);
                }
            }
        }
        return result;
    }

    @Override
    public String toString(Map<InputValue, Object> values) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<InputValue, Object> entry : values.entrySet()) {
            result.put(entry.getKey().getName(), entry.getValue());
        }
        ObjectMapper mapper = this.createMapper();
        return mapper.writeValueAsString(result);
    }

    private ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("ChemClipse", Version.unknownVersion());
        module.setAbstractTypes(RESOLVER);
        mapper.registerModule((Module)module);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }

    @Override
    public void updateFromString(Object object, String content) throws IOException {
        if (object != null && content != null && !content.isEmpty()) {
            this.createMapper().readerForUpdating(object).readValue(content);
        }
    }

    @Override
    public String toString(Object settingsObject) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(settingsObject);
    }

    public static <T> void addMapping(Class<T> superType, Class<? extends T> subType) {
        MAPPINGS.put(superType, subType);
    }

    public static <T> void removeMapping(Class<T> superType, Class<? extends T> subType) {
        MAPPINGS.remove(superType, subType);
    }
}

