/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.settings.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class MinMaxValidator<T extends Number>
implements IValidator {
    private String fieldName;
    private T min;
    private T max;
    private Class<T> type;

    public MinMaxValidator(String fieldName, T min, T max, Class<T> type) {
        this.fieldName = fieldName;
        this.min = min;
        this.max = max;
        this.type = type;
    }

    public IStatus validate(Object value) {
        if (this.type.isInstance(value)) {
            Number number = (Number)this.type.cast(value);
            if (((Comparable)((Object)number)).compareTo(this.min) < 0) {
                return ValidationStatus.error((String)(String.valueOf(this.fieldName) + " can't be smaller than " + this.min));
            }
            if (((Comparable)((Object)number)).compareTo(this.max) > 0) {
                return ValidationStatus.error((String)(String.valueOf(this.fieldName) + " can't be larger than " + this.max));
            }
            return ValidationStatus.ok();
        }
        return ValidationStatus.error((String)("A number between " + this.min + " and " + this.max + " is required for " + this.fieldName));
    }
}

