/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.settings.validation;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class RegularExpressionValidator
implements IValidator {
    private String fieldName;
    private Pattern regExp;
    private boolean multiline;

    public RegularExpressionValidator(String fieldName, Pattern regExp, boolean multiline) {
        this.fieldName = fieldName;
        this.regExp = regExp;
        this.multiline = multiline;
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (this.multiline) {
                String[] lines = string.split("[\r\n]+");
                int n = 1;
                String[] stringArray = lines;
                int n2 = lines.length;
                int n3 = 0;
                while (n3 < n2) {
                    String line = stringArray[n3];
                    if (!this.regExp.matcher(line).matches()) {
                        return ValidationStatus.error((String)("Line #" + n + " of " + this.fieldName + " is not formatted correctly."));
                    }
                    ++n;
                    ++n3;
                }
            } else if (!this.regExp.matcher(string).matches()) {
                return ValidationStatus.error((String)(String.valueOf(this.fieldName) + " must match " + this.regExp.pattern()));
            }
            return ValidationStatus.ok();
        }
        return ValidationStatus.error((String)("A value is required for " + this.fieldName));
    }
}

