/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui;

import java.net.URL;
import java.util.MissingResourceException;
import org.eclipse.chemclipse.ux.extension.ui.definitions.TileDefinition;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String INFO_PERSPECTIVES = "Perspectives";
    public static final String PATH_PERSPECTIVES_INFO = "files/images/perspectives.png";
    private static Activator plugin;
    private ServiceTracker<TileDefinition, TileDefinition> tileServiceTracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initializeImageRegistry();
        this.tileServiceTracker = new ServiceTracker(context, TileDefinition.class, null);
        this.tileServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.tileServiceTracker.close();
        this.tileServiceTracker = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public TileDefinition[] getTileDefinitions() {
        Object[] array = new TileDefinition[]{};
        if (this.tileServiceTracker == null) {
            return array;
        }
        return (TileDefinition[])this.tileServiceTracker.getServices(array);
    }

    private void initializeImageRegistry() {
        try {
            URL fileLocation = Activator.getAbsolutePath(PATH_PERSPECTIVES_INFO);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)fileLocation);
            ImageRegistry imageRegistry = this.getImageRegistry();
            if (imageRegistry != null) {
                this.getImageRegistry().put(INFO_PERSPECTIVES, imageDescriptor);
            }
        }
        catch (MissingResourceException e) {
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    public static URL getAbsolutePath(String string) {
        Bundle bundle = Platform.getBundle((String)Activator.getDefault().getBundle().getSymbolicName());
        Path path = new Path(string);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        return url;
    }
}

