/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.swt;

import org.eclipse.chemclipse.ux.extension.ui.definitions.TileDefinition;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TileSelectionDialog
extends Dialog {
    private TileDefinition[] elements;
    private CellLabelProvider labelProvider;
    private TileDefinition selectedElement;

    public TileSelectionDialog(Shell parentShell, TileDefinition[] elements, CellLabelProvider labelProvider) {
        super(parentShell);
        this.elements = elements;
        this.labelProvider = labelProvider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        TableViewer tableViewer = new TableViewer(composite);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.setLabelProvider(this.labelProvider);
        column.getColumn().setWidth(300);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput((Object)this.elements);
        Control control = tableViewer.getControl();
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object selected = ((IStructuredSelection)selection).getFirstElement();
                    if (selected instanceof TileDefinition) {
                        TileSelectionDialog.this.selectedElement = (TileDefinition)selected;
                    } else {
                        TileSelectionDialog.this.selectedElement = null;
                    }
                }
            }
        });
        return composite;
    }

    public TileDefinition getSelectedElement() {
        return this.selectedElement;
    }
}

