/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.views;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Named;
import org.eclipse.chemclipse.rcp.app.ui.dialogs.PerspectiveChooserDialog;
import org.eclipse.chemclipse.support.ui.workbench.PerspectiveSupport;
import org.eclipse.chemclipse.ux.extension.ui.Activator;
import org.eclipse.chemclipse.ux.extension.ui.definitions.TileDefinition;
import org.eclipse.chemclipse.ux.extension.ui.swt.TaskTile;
import org.eclipse.chemclipse.ux.extension.ui.swt.TaskTileContainer;
import org.eclipse.chemclipse.ux.extension.ui.swt.TileSelectionDialog;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class WelcomeViewExtensionHandler {
    public static final String PREFERENCE_MIN_TILES = "WelcomeViewExtensionHandler.minTiles";
    public static final String PREFERENCE_MAX_TILES = "WelcomeViewExtensionHandler.maxTiles";
    public static final String PREFERENCE_ALWAYS_CHANGE_PERSPECTIVE = "WelcomeViewExtensionHandler.changePerspective";
    private static final String PREFERENCE_ADDED = "WelcomeViewExtensionHandler.addedTiles";
    private static final String PREFERENCE_REMOVED = "WelcomeViewExtensionHandler.removedTiles";
    private static final String DATA_POPUP_MENU = "WelcomeViewExtensionHandler.POPUP";
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.ux.extension.ui.welcometile";
    private static final String ATTRIBUTE_SECTION = "Section";
    private static final String ATTRIBUTE_DESCRIPTION = "Description";
    private static final String ATTRIBUTE_PERSPECTIVE_ID = "PerspectiveId";
    private static final String ATTRIBUTE_DEFAULTSHOW = "defaultShow";
    private static final Comparator<TileDefinition> EXTENSION_COMPARATOR = (c1, c2) -> c1.getTitle().compareToIgnoreCase(c2.getTitle());
    private final Set<String> removedTiles;
    private final Set<String> addedTiles;
    private final Set<TileDefinition> privateTileDefinitions = new HashSet<TileDefinition>();
    private final TaskTileContainer tileContainer;
    private final int minTiles;
    private final int maxTiles;
    private int tiles;
    private final IPreferenceStore preferenceStore;
    private final Predicate<TileDefinition> definitionAcceptor;
    private String subcontext;

    public WelcomeViewExtensionHandler(TaskTileContainer tileContainer, IPreferenceStore preferenceStore, String subcontext) {
        this(tileContainer, preferenceStore, subcontext, tile -> tile.matches(subcontext));
    }

    private WelcomeViewExtensionHandler(TaskTileContainer tileContainer, IPreferenceStore preferenceStore, String subcontext, Predicate<TileDefinition> definitionAcceptor) {
        this.tileContainer = tileContainer;
        this.preferenceStore = preferenceStore;
        this.subcontext = subcontext;
        this.definitionAcceptor = definitionAcceptor;
        this.minTiles = preferenceStore.getInt(PREFERENCE_MIN_TILES);
        this.maxTiles = Math.max(this.minTiles, preferenceStore.getInt(PREFERENCE_MAX_TILES));
        this.addedTiles = WelcomeViewExtensionHandler.restoreSet(preferenceStore.getString(PREFERENCE_ADDED));
        this.removedTiles = WelcomeViewExtensionHandler.restoreSet(preferenceStore.getString(PREFERENCE_REMOVED));
        this.initTiles();
    }

    private void initTiles() {
        for (TileDefinition tileDefinition : this.getAllExtensions()) {
            String id = this.getExtensionId(tileDefinition);
            if (!this.addedTiles.contains(id)) continue;
            WelcomeViewExtensionHandler.setTile(this.createTile(), tileDefinition, true);
        }
        while (this.tiles < this.minTiles) {
            this.createTile();
        }
        this.updateTiles();
    }

    public TaskTile createTile() {
        if (this.tiles < this.maxTiles) {
            final ExtensionTileDefinition definition = new ExtensionTileDefinition();
            final TaskTile tile = this.tileContainer.addTaskTile(definition);
            Menu popupMenu = new Menu((Control)tile);
            MenuItem deleteItem = new MenuItem(popupMenu, 0);
            deleteItem.setText("Remove Shortcut");
            deleteItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String extensionId = WelcomeViewExtensionHandler.this.getExtensionId(definition.delegate);
                    definition.delegate = null;
                    WelcomeViewExtensionHandler.this.removedTiles.add(extensionId);
                    WelcomeViewExtensionHandler.this.addedTiles.remove(extensionId);
                    if (WelcomeViewExtensionHandler.this.tiles > WelcomeViewExtensionHandler.this.minTiles) {
                        WelcomeViewExtensionHandler.this.tileContainer.removeTaskTile(tile);
                        WelcomeViewExtensionHandler welcomeViewExtensionHandler = WelcomeViewExtensionHandler.this;
                        welcomeViewExtensionHandler.tiles = welcomeViewExtensionHandler.tiles - 1;
                    }
                    try {
                        WelcomeViewExtensionHandler.this.updateTiles();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            tile.setData(DATA_POPUP_MENU, popupMenu);
            ++this.tiles;
            return tile;
        }
        return null;
    }

    public void addTileDefinition(TileDefinition definition) {
        this.privateTileDefinitions.add(definition);
        this.updateTiles();
    }

    public void removeTileDefinition(TileDefinition definition) {
        this.privateTileDefinitions.remove(definition);
        this.updateTiles();
    }

    private String getExtensionId(TileDefinition extension) {
        if (extension instanceof ConfigurationElementTileDefinition) {
            ConfigurationElementTileDefinition elementTileDefinition = (ConfigurationElementTileDefinition)extension;
            return String.valueOf(elementTileDefinition.element.getContributor().getName()) + "#" + elementTileDefinition.element.getAttribute(ATTRIBUTE_SECTION);
        }
        if (extension != null) {
            return extension.getClass().getName();
        }
        return "";
    }

    private void updateTiles() {
        IPersistentPreferenceStore store;
        List<TileDefinition> unusedExtensions = this.getUnusedExtensions();
        List<TileDefinition> used = this.getUsedExtensions();
        Iterator<TileDefinition> iterator = unusedExtensions.iterator();
        while (iterator.hasNext()) {
            if (used.size() >= this.maxTiles - 1) break;
            TileDefinition defaultExtension = iterator.next();
            if (!defaultExtension.isDefaultShow(this.subcontext) || this.removedTiles.contains(this.getExtensionId(defaultExtension))) continue;
            iterator.remove();
            used.add(defaultExtension);
        }
        Collections.sort(used, EXTENSION_COMPARATOR);
        boolean hasShortcut = unusedExtensions.isEmpty();
        for (TaskTile tile : this.tileContainer.getTiles()) {
            hasShortcut = this.updateTile(used, hasShortcut, tile);
        }
        while (!used.isEmpty() || !hasShortcut) {
            TaskTile tile;
            tile = this.createTile();
            if (tile == null) break;
            hasShortcut = this.updateTile(used, hasShortcut, tile);
        }
        this.preferenceStore.setValue(PREFERENCE_ADDED, WelcomeViewExtensionHandler.serializeSet(this.addedTiles));
        this.preferenceStore.setValue(PREFERENCE_REMOVED, WelcomeViewExtensionHandler.serializeSet(this.removedTiles));
        if (this.preferenceStore instanceof IPersistentPreferenceStore && (store = (IPersistentPreferenceStore)this.preferenceStore).needsSaving()) {
            try {
                store.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean updateTile(List<TileDefinition> used, boolean hasShortcut, TaskTile tile) {
        TileDefinition definition = tile.getDefinition();
        if (definition instanceof ExtensionTileDefinition) {
            TileDefinition extension = used.isEmpty() ? null : used.remove(0);
            hasShortcut = WelcomeViewExtensionHandler.setTile(tile, extension, hasShortcut);
        }
        return hasShortcut;
    }

    private static boolean setTile(TaskTile tile, TileDefinition extension, boolean hasShortcut) {
        if (tile == null) {
            return false;
        }
        ExtensionTileDefinition extensionTileDefinition = (ExtensionTileDefinition)tile.getDefinition();
        extensionTileDefinition.delegate = extension;
        if (extension != null) {
            tile.setMenu((Menu)tile.getData(DATA_POPUP_MENU));
            extensionTileDefinition.addshortcut = false;
        } else {
            tile.setMenu(null);
            if (!hasShortcut) {
                extensionTileDefinition.addshortcut = true;
                hasShortcut = true;
            } else {
                extensionTileDefinition.addshortcut = false;
            }
        }
        tile.updateFromDefinition();
        return hasShortcut;
    }

    private void selectExtensionForTile(ExtensionTileDefinition definition, final Shell shell, final PerspectiveSupport perspectiveSupport) {
        List<TileDefinition> allExtensions = this.getUnusedExtensions();
        TileSelectionDialog dialog = new TileSelectionDialog(shell, allExtensions.toArray(new TileDefinition[0]), (CellLabelProvider)new ColumnLabelProvider(){
            Map<IConfigurationElement, Image> images = new IdentityHashMap<IConfigurationElement, Image>();

            public String getText(Object element) {
                ILabelProvider labelProvider = (ILabelProvider)Adapters.adapt((Object)element, ILabelProvider.class);
                if (labelProvider != null) {
                    return labelProvider.getText(element);
                }
                if (element instanceof TileDefinition) {
                    return ((TileDefinition)element).getTitle();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof ConfigurationElementTileDefinition) {
                    String iconURI;
                    MPerspective perspectiveModel;
                    IConfigurationElement configurationElement = ((ConfigurationElementTileDefinition)element).element;
                    Image image = this.images.get(configurationElement);
                    if (image == null && (perspectiveModel = perspectiveSupport.getPerspectiveModel(configurationElement.getAttribute(WelcomeViewExtensionHandler.ATTRIBUTE_PERSPECTIVE_ID))) != null && (iconURI = perspectiveModel.getIconURI()) != null) {
                        try {
                            Throwable throwable = null;
                            Object var7_10 = null;
                            try (InputStream stream = new URL(iconURI).openStream();){
                                image = new Image((Device)shell.getDisplay(), stream);
                                this.images.put(configurationElement, image);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return image;
                }
                ILabelProvider labelProvider = (ILabelProvider)Adapters.adapt((Object)element, ILabelProvider.class);
                if (labelProvider != null) {
                    return labelProvider.getImage(element);
                }
                return super.getImage(element);
            }

            public void dispose() {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
                super.dispose();
            }
        });
        if (dialog.open() == 0) {
            TileDefinition element = dialog.getSelectedElement();
            definition.delegate = element;
            definition.addshortcut = false;
            String extensionId = this.getExtensionId(element);
            this.removedTiles.remove(extensionId);
            this.addedTiles.add(extensionId);
            this.updateTiles();
        }
    }

    private List<TileDefinition> getUnusedExtensions() {
        List<TileDefinition> allExtensions = this.getAllExtensions();
        allExtensions.removeAll(this.getUsedExtensions());
        return allExtensions;
    }

    private List<TileDefinition> getUsedExtensions() {
        ArrayList<TileDefinition> usedExtensions = new ArrayList<TileDefinition>();
        for (TaskTile tile : this.tileContainer.getTiles()) {
            TileDefinition extension;
            TileDefinition definition = tile.getDefinition();
            if (!(definition instanceof ExtensionTileDefinition) || (extension = ((ExtensionTileDefinition)definition).delegate) == null) continue;
            usedExtensions.add(extension);
        }
        return usedExtensions;
    }

    private List<TileDefinition> getAllExtensions() {
        TileDefinition[] definitions;
        IConfigurationElement[] elements;
        ArrayList<TileDefinition> result = new ArrayList<TileDefinition>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ConfigurationElementTileDefinition definition = new ConfigurationElementTileDefinition(element);
            if (this.definitionAcceptor != null && this.definitionAcceptor.test(definition)) {
                result.add(definition);
            }
            ++n2;
        }
        TileDefinition[] tileDefinitionArray = definitions = Activator.getDefault().getTileDefinitions();
        int n3 = definitions.length;
        n = 0;
        while (n < n3) {
            TileDefinition definition = tileDefinitionArray[n];
            if (this.definitionAcceptor != null && this.definitionAcceptor.test(definition)) {
                result.add(definition);
            }
            ++n;
        }
        result.addAll(this.privateTileDefinitions);
        return result;
    }

    private static String serializeSet(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        for (String key : set) {
            if (sb.length() > 0) {
                sb.append('\t');
            }
            sb.append(key);
        }
        return sb.toString();
    }

    private static Set<String> restoreSet(String serializedSet) {
        HashSet<String> result = new HashSet<String>();
        if (serializedSet != null && !serializedSet.trim().isEmpty()) {
            result.addAll(Arrays.asList(serializedSet.split("\t")));
        }
        return result;
    }

    private final class ConfigurationElementTileDefinition
    implements TileDefinition {
        private final IConfigurationElement element;

        public ConfigurationElementTileDefinition(IConfigurationElement element) {
            this.element = element;
        }

        @Override
        public String getTitle() {
            return this.element.getAttribute(WelcomeViewExtensionHandler.ATTRIBUTE_SECTION);
        }

        @Override
        public String getDescription() {
            return this.element.getAttribute(WelcomeViewExtensionHandler.ATTRIBUTE_DESCRIPTION);
        }

        @Override
        public boolean isDefaultShow(String subcontext) {
            return Boolean.parseBoolean(this.element.getAttribute(WelcomeViewExtensionHandler.ATTRIBUTE_DEFAULTSHOW));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConfigurationElementTileDefinition) {
                return this.element.equals((Object)((ConfigurationElementTileDefinition)obj).element);
            }
            return false;
        }

        @Override
        public String getPreferredPerspective() {
            return this.element.getAttribute(WelcomeViewExtensionHandler.ATTRIBUTE_PERSPECTIVE_ID);
        }

        @Override
        public String getContext() {
            return "perspective-switch," + this.getPreferredPerspective();
        }

        @CanExecute
        public boolean canExecute(PerspectiveSupport perspectiveSupport) {
            String perspectiveId = this.getPreferredPerspective();
            if (perspectiveId == null || perspectiveId.isEmpty()) {
                return false;
            }
            return perspectiveSupport.getPerspectiveModel(perspectiveId) != null;
        }
    }

    private final class ExtensionTileDefinition
    implements TileDefinition {
        private boolean addshortcut;
        private TileDefinition delegate;

        private ExtensionTileDefinition() {
        }

        @Override
        public String getTitle() {
            if (this.delegate != null) {
                return this.delegate.getTitle();
            }
            if (this.addshortcut) {
                return "+";
            }
            return "";
        }

        @Override
        public String getDescription() {
            if (this.delegate != null) {
                return this.delegate.getDescription();
            }
            if (this.addshortcut) {
                return "Add shortcut";
            }
            return "";
        }

        @Override
        public boolean isDefaultShow(String context) {
            if (this.delegate != null) {
                return this.delegate.isDefaultShow(context);
            }
            return false;
        }

        @Override
        public String getContext() {
            if (this.delegate != null) {
                return this.delegate.getContext();
            }
            return TileDefinition.super.getContext();
        }

        @Override
        public Image getIcon() {
            if (this.delegate != null) {
                return this.delegate.getIcon();
            }
            return null;
        }

        @Execute
        public void execute(PerspectiveSupport perspectiveSupport, @Named(value="activeShell") Shell shell, IEclipseContext context) {
            if (this.delegate != null) {
                MPerspective model;
                String preferredPerspective = this.delegate.getPreferredPerspective();
                if (preferredPerspective != null && !preferredPerspective.isEmpty() && (model = perspectiveSupport.getPerspectiveModel(preferredPerspective)) != null) {
                    boolean changePerspective;
                    boolean bl = changePerspective = this.delegate instanceof ConfigurationElementTileDefinition || WelcomeViewExtensionHandler.this.preferenceStore.getBoolean(WelcomeViewExtensionHandler.PREFERENCE_ALWAYS_CHANGE_PERSPECTIVE);
                    if (!changePerspective) {
                        PerspectiveChooserDialog dialog = new PerspectiveChooserDialog(shell, "Change Perspective?", "Perspectives offer the best user experience and special views to optimize the workflow. This task is associated with the " + model.getLabel() + " perspective do you like to change? ", WelcomeViewExtensionHandler.this.preferenceStore, WelcomeViewExtensionHandler.PREFERENCE_ALWAYS_CHANGE_PERSPECTIVE);
                        boolean bl2 = changePerspective = dialog.open() == 0;
                    }
                    if (changePerspective) {
                        perspectiveSupport.changePerspective(preferredPerspective);
                    }
                }
                ContextInjectionFactory.invoke((Object)this.delegate, Execute.class, (IEclipseContext)context, null);
            } else if (this.addshortcut) {
                WelcomeViewExtensionHandler.this.selectExtensionForTile(this, shell, perspectiveSupport);
            }
        }

        @CanExecute
        public boolean canExecute(IEclipseContext context) {
            if (this.delegate != null) {
                Object invoke = ContextInjectionFactory.invoke((Object)this.delegate, CanExecute.class, (IEclipseContext)context, (Object)Boolean.TRUE);
                if (invoke instanceof Boolean) {
                    return (Boolean)invoke;
                }
                return true;
            }
            return this.addshortcut;
        }
    }
}

