/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui;

import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.DataUpdateSupport;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private ScopedPreferenceStore preferenceStoreSubtract;
    private DataUpdateSupport dataUpdateSupport;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initializePreferenceStoreSubtract(PreferenceSupplier.INSTANCE());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.dataUpdateSupport = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ScopedPreferenceStore getPreferenceStoreSubtract() {
        return this.preferenceStoreSubtract;
    }

    public String getSettingsPath() {
        Location location = Platform.getUserLocation();
        return location.getURL().getPath().toString();
    }

    public DataUpdateSupport getDataUpdateSupport() {
        if (this.dataUpdateSupport == null) {
            this.dataUpdateSupport = new DataUpdateSupport(this.getEventBroker());
            this.initialize(this.dataUpdateSupport);
        }
        return this.dataUpdateSupport;
    }

    public IEclipseContext getEclipseContext() {
        BundleContext bundleContext = this.getBundle().getBundleContext();
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        eclipseContext.set(Logger.class, null);
        return eclipseContext;
    }

    public IEventBroker getEventBroker() {
        IEclipseContext eclipseContext = this.getEclipseContext();
        return (IEventBroker)eclipseContext.get(IEventBroker.class);
    }

    private void initialize(DataUpdateSupport dataUpdateSupport) {
        dataUpdateSupport.subscribe("chromatogram/msd/update/chromatogramselection", "ChromatogramSelection");
        dataUpdateSupport.subscribe("chromatogram/csd/update/chromatogramselection", "ChromatogramSelection");
        dataUpdateSupport.subscribe("chromatogram/wsd/update/chromatogramselection", "ChromatogramSelection");
        dataUpdateSupport.subscribe("chromatogram/xxd/load/chromatogramselection", "org.eclipse.e4.data");
        dataUpdateSupport.subscribe("scan/xxd/update/selection", "org.eclipse.e4.data");
        dataUpdateSupport.subscribe("peak/xxd/update/selection", "org.eclipse.e4.data");
        dataUpdateSupport.subscribe("identification/targets/update/selection", "org.eclipse.e4.data");
        dataUpdateSupport.subscribe("chromatogram/xxd/unload/chromatogramselection", "org.eclipse.e4.data");
        dataUpdateSupport.subscribe("scan/xxd/unload/selection", "org.eclipse.e4.data");
        dataUpdateSupport.subscribe("peak/xxd/unload/selection", "org.eclipse.e4.data");
        dataUpdateSupport.subscribe("identification/targets/unload/selection", "org.eclipse.e4.data");
    }

    private void initializePreferenceStoreSubtract(IPreferenceSupplier preferenceSupplier) {
        if (preferenceSupplier != null) {
            this.preferenceStoreSubtract = new ScopedPreferenceStore(preferenceSupplier.getScopeContext(), preferenceSupplier.getPreferenceNode());
            Map initializationEntries = preferenceSupplier.getDefaultValues();
            for (Map.Entry entry : initializationEntries.entrySet()) {
                this.preferenceStoreSubtract.setDefault((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

