/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.charts.TargetReferenceLabelMarker;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.SignalTargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.TargetDisplaySettingsWizard;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.TargetDisplaySettingsWizardListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.IScrollableChart;

public class TargetLabelEditAction
extends Action {
    public static final boolean DEF_SHOW_PREVIEW = false;
    public static final String P_SHOW_PREVIEW = "TargetLabelEditAction.showPreview";
    private final LabelChart labelChart;
    private final IPreferenceStore preferenceStore;
    private final List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

    public TargetLabelEditAction(LabelChart labelChart, IPreferenceStore preferenceStore) {
        super("Labels", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/labels.png", "16x16"));
        this.labelChart = labelChart;
        this.preferenceStore = preferenceStore;
        this.setToolTipText("Mange the labels to display in the chromatogram");
        this.setShowPreviewDefault(false);
    }

    public void setShowPreviewDefault(boolean previewDefaultValue) {
        if (this.preferenceStore != null) {
            this.preferenceStore.setDefault(P_SHOW_PREVIEW, previewDefaultValue);
        }
    }

    public void run() {
        final IChromatogramSelection<?, ?> chromatogramSelection = this.labelChart.getChromatogramSelection();
        if (chromatogramSelection != null) {
            List identifications;
            try {
                identifications = (List)DisplayUtils.executeBusy(() -> {
                    ArrayList<SignalTargetReference> list = new ArrayList<SignalTargetReference>();
                    list.addAll(SignalTargetReference.getPeakReferences(chromatogramSelection.getChromatogram().getPeaks()));
                    list.addAll(SignalTargetReference.getScanReferences(ChromatogramDataSupport.getIdentifiedScans(chromatogramSelection.getChromatogram())));
                    Collections.sort(list, new Comparator<SignalTargetReference>(){

                        @Override
                        public int compare(SignalTargetReference o1, SignalTargetReference o2) {
                            int compare = Double.compare(o1.getSignal().getX(), o2.getSignal().getX());
                            if (compare == 0) {
                                return o1.getName().compareToIgnoreCase(o2.getName());
                            }
                            return compare;
                        }
                    });
                    return list;
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                throw new RuntimeException("can't get reference", e.getCause());
            }
            final IScrollableChart chart = this.labelChart.getChart();
            final TargetReferenceLabelMarker previewMarker = new TargetReferenceLabelMarker(chart.getBaseChart(), true, 10, this.preferenceStore);
            chart.getBaseChart().getPlotArea().addCustomPaintListener((ICustomPaintListener)previewMarker);
            TargetDisplaySettingsWizardListener listener = new TargetDisplaySettingsWizardListener(){
                boolean previewDisabled = true;
                private boolean showPreview;

                @Override
                public String getIDLabel() {
                    return "RT";
                }

                @Override
                public void setPreviewSettings(TargetDisplaySettings previewSettings, Predicate<TargetReference> activeFilter) {
                    if (previewSettings == null && this.previewDisabled) {
                        return;
                    }
                    this.previewDisabled = previewSettings == null;
                    TargetLabelEditAction.this.labelChart.setChartMarkerVisible(this.previewDisabled);
                    Predicate<TargetReference> settingsFilter = previewMarker.setData(identifications, previewSettings, activeFilter);
                    if (this.previewDisabled) {
                        chart.setRange("X_AXIS", new Range((double)chromatogramSelection.getStartRetentionTime(), (double)chromatogramSelection.getStopRetentionTime()));
                    } else {
                        double minRT = Double.NaN;
                        double maxRT = Double.NaN;
                        for (SignalTargetReference scanTargetReference : identifications) {
                            if (!settingsFilter.test(scanTargetReference) || activeFilter != null && !activeFilter.test(scanTargetReference)) continue;
                            double rt = scanTargetReference.getSignal().getX();
                            if (Double.isNaN(minRT) || rt < minRT) {
                                minRT = rt;
                            }
                            if (!Double.isNaN(maxRT) && !(rt > maxRT)) continue;
                            maxRT = rt;
                        }
                        int absStart = chromatogramSelection.getChromatogram().getStartRetentionTime();
                        if (Double.isNaN(minRT)) {
                            minRT = absStart;
                        }
                        int absStop = chromatogramSelection.getChromatogram().getStopRetentionTime();
                        if (Double.isNaN(maxRT)) {
                            maxRT = absStop;
                        }
                        long windowOffset = TimeUnit.MINUTES.toMillis(1L);
                        chart.setRange("X_AXIS", new Range(Math.max(minRT - (double)windowOffset, (double)absStart), Math.min((double)absStop, maxRT + (double)windowOffset)));
                    }
                    TargetLabelEditAction.this.labelChart.redraw();
                }

                @Override
                public boolean isShowPreview() {
                    if (TargetLabelEditAction.this.preferenceStore != null) {
                        return TargetLabelEditAction.this.preferenceStore.getBoolean(TargetLabelEditAction.P_SHOW_PREVIEW);
                    }
                    return this.showPreview;
                }

                @Override
                public void setShowPreview(boolean preview) {
                    if (TargetLabelEditAction.this.preferenceStore != null) {
                        TargetLabelEditAction.this.preferenceStore.setValue(TargetLabelEditAction.P_SHOW_PREVIEW, preview);
                    }
                    this.showPreview = preview;
                }
            };
            boolean settingsChanged = TargetDisplaySettingsWizard.openWizard(chart.getBaseChart().getShell(), identifications, listener, this.labelChart.getTargetSettings());
            chart.getBaseChart().getPlotArea().removeCustomPaintListener((ICustomPaintListener)previewMarker);
            listener.setPreviewSettings(null, null);
            if (settingsChanged) {
                this.listeners.forEach(Runnable::run);
            }
        }
    }

    public void addChangeListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public static interface LabelChart {
        public IScrollableChart getChart();

        public void redraw();

        public TargetDisplaySettings getTargetSettings();

        public IChromatogramSelection<?, ?> getChromatogramSelection();

        public void setChartMarkerVisible(boolean var1);
    }
}

