/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.charts;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;

public class ChartPCR
extends LineChart {
    public ChartPCR() {
        this.initialize();
    }

    public ChartPCR(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        this.modify();
    }

    private void modify() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(false);
        chartSettings.getRangeRestriction().setZeroY(false);
        this.setPrimaryAxisSet(chartSettings);
        this.addSecondaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("Scan");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsX.setPosition(IAxis.Position.Primary);
        primaryAxisSettingsX.setVisible(true);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Intensity");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
    }

    private void addSecondaryAxisSet(IChartSettings chartSettings) {
        this.deleteSecondaryAxes(chartSettings);
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings("Relative Intensity [%]", (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private void deleteSecondaryAxes(IChartSettings chartSettings) {
        chartSettings.getSecondaryAxisSettingsListX().clear();
        chartSettings.getSecondaryAxisSettingsListY().clear();
    }
}

