/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.charts;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;

public class ChartXIR
extends LineChart {
    public ChartXIR() {
        this.initialize();
    }

    public ChartXIR(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void modifyChart(boolean rawData) {
        if (rawData) {
            this.modifyRaw();
        } else {
            this.modifyProcessed();
        }
    }

    private void initialize() {
        this.modifyProcessed();
    }

    private void modifyRaw() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(false);
        chartSettings.getRangeRestriction().setZeroY(false);
        chartSettings.getRangeRestriction().setForceZeroMinY(false);
        this.setPrimaryAxisSetRaw(chartSettings);
        this.addSecondaryAxisSetRaw(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSetRaw(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("Mirror Position");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsX.setPosition(IAxis.Position.Primary);
        primaryAxisSettingsX.setVisible(true);
        primaryAxisSettingsX.setReversed(false);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Light measured by detector");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsY.setVisible(true);
        primaryAxisSettingsY.setReversed(false);
    }

    private void addSecondaryAxisSetRaw(IChartSettings chartSettings) {
        this.deleteSecondaryAxes(chartSettings);
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings("Relative Intensity [%]", (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private void modifyProcessed() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(true);
        chartSettings.getRangeRestriction().setZeroY(true);
        chartSettings.getRangeRestriction().setForceZeroMinY(true);
        this.setPrimaryAxisSetProcessed(chartSettings);
        this.addSecondaryAxisSetProcessed(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSetProcessed(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("Wavelength (nm)");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsX.setVisible(true);
        primaryAxisSettingsX.setReversed(true);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Intensity");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsY.setGridLineStyle(LineStyle.NONE);
        primaryAxisSettingsY.setVisible(true);
        primaryAxisSettingsY.setReversed(true);
    }

    private void addSecondaryAxisSetProcessed(IChartSettings chartSettings) {
        this.deleteSecondaryAxes(chartSettings);
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings("Relative Intensity [%]", (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private void deleteSecondaryAxes(IChartSettings chartSettings) {
        chartSettings.getSecondaryAxisSettingsListX().clear();
        chartSettings.getSecondaryAxisSettingsListY().clear();
    }
}

