/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.fieldeditors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.ITargetTemplate;
import org.eclipse.chemclipse.model.identifier.TargetTemplate;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverterSupport;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.DatabaseImportRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.TargetTemplateInputValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.TargetTemplates;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.TargetTemplateListUI;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TargetFieldEditor
extends FieldEditor {
    private static final Logger logger = Logger.getLogger(TargetFieldEditor.class);
    private static final int NUMBER_COLUMNS = 2;
    private static final int WARN_NUMBER_IMPORT_ENTRIES = 500;
    private static final String FILTER_EXTENSION = "*.txt";
    private static final String FILTER_NAME = "Target List (*.txt)";
    private static final String FILE_NAME = "TargetList.txt";
    private Composite composite;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private TargetTemplates targetTemplates = new TargetTemplates();
    private TargetTemplateListUI targetTemplateListUI;

    public TargetFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        this.createLabelSection(this.composite);
        this.createSearchSection(this.composite);
        this.createTableSection(this.composite);
        this.createButtonGroup(this.composite);
    }

    private void createSearchSection(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        searchSupportUI.setLayoutData((Object)gridData);
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                TargetFieldEditor.this.targetTemplateListUI.setSearchText(searchText, caseSensitive);
            }
        });
    }

    private void createLabelSection(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createTableSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.targetTemplateListUI = new TargetTemplateListUI(composite, 68354);
        this.setTableViewerInput();
    }

    private void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.setButtonLayoutData(this.createButtonAdd(composite));
        this.setButtonLayoutData(this.createButtonEdit(composite));
        this.setButtonLayoutData(this.createButtonRemove(composite));
        this.setButtonLayoutData(this.createButtonRemoveAll(composite));
        this.setButtonLayoutData(this.createButtonImportDB(composite));
        this.setButtonLayoutData(this.createButtonImport(composite));
        this.setButtonLayoutData(this.createButtonExport(composite));
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add");
        button.setToolTipText("Add a target template.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(e.display.getActiveShell(), "Target", "You can create a new target here.", "Styrene | 100-42-5 | comment | contributor | referenceId", (IInputValidator)new TargetTemplateInputValidator(TargetFieldEditor.this.targetTemplates.keySet()));
                if (dialog.open() == 0) {
                    String item = dialog.getValue();
                    ITargetTemplate targetTemplate = TargetFieldEditor.this.targetTemplates.extractTargetTemplate(item);
                    if (targetTemplate != null) {
                        TargetFieldEditor.this.targetTemplates.add(targetTemplate);
                        TargetFieldEditor.this.setTableViewerInput();
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonEdit(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Edit");
        button.setToolTipText("Edit the selected target template.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = (IStructuredSelection)TargetFieldEditor.this.targetTemplateListUI.getSelection();
                Object object = structuredSelection.getFirstElement();
                if (object instanceof ITargetTemplate) {
                    HashSet<String> keySetEdit = new HashSet<String>();
                    keySetEdit.addAll(TargetFieldEditor.this.targetTemplates.keySet());
                    ITargetTemplate targetTemplate = (ITargetTemplate)object;
                    keySetEdit.remove(targetTemplate.getName());
                    InputDialog dialog = new InputDialog(e.display.getActiveShell(), "Target", "Edit the target.", TargetFieldEditor.this.targetTemplates.extractTargetTemplate(targetTemplate), (IInputValidator)new TargetTemplateInputValidator(keySetEdit));
                    if (dialog.open() == 0) {
                        String item = dialog.getValue();
                        ITargetTemplate targetTemplateNew = TargetFieldEditor.this.targetTemplates.extractTargetTemplate(item);
                        if (targetTemplateNew != null) {
                            targetTemplate.setName(targetTemplateNew.getName());
                            targetTemplate.setCasNumber(targetTemplateNew.getCasNumber());
                            targetTemplate.setComments(targetTemplateNew.getComments());
                            targetTemplate.setContributor(targetTemplateNew.getContributor());
                            targetTemplate.setReferenceId(targetTemplateNew.getReferenceId());
                            TargetFieldEditor.this.setTableViewerInput();
                        }
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove");
        button.setToolTipText("Remove the selected target template(s).");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Target Template(s)", (String)"Do you want to delete the selected target template(s)?")) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)TargetFieldEditor.this.targetTemplateListUI.getSelection();
                    Object[] objectArray = structuredSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof ITargetTemplate) {
                            TargetFieldEditor.this.targetTemplates.remove(((ITargetTemplate)object).getName());
                        }
                        ++n2;
                    }
                    TargetFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonRemoveAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove All");
        button.setToolTipText("Remove all target template(s).");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Target Template(s)", (String)"Do you want to delete all target template(s)?")) {
                    TargetFieldEditor.this.targetTemplates.clear();
                    TargetFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonImportDB(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Import Library");
        button.setToolTipText("Import a target template(s) from a library.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DatabaseConverterSupport databaseConverterSupport = DatabaseConverter.getDatabaseConverterSupport();
                    FileDialog fileDialog = new FileDialog(e.display.getActiveShell(), 8);
                    fileDialog.setText("Select a library to import");
                    fileDialog.setFilterExtensions(databaseConverterSupport.getFilterExtensions());
                    fileDialog.setFilterNames(databaseConverterSupport.getFilterNames());
                    fileDialog.setFilterPath(TargetFieldEditor.this.preferenceStore.getString("targetTemplateLibraryImportFolder"));
                    String pathname = fileDialog.open();
                    if (pathname != null) {
                        File file = new File(pathname);
                        String path = file.getParentFile().getAbsolutePath();
                        TargetFieldEditor.this.preferenceStore.putValue("targetTemplateLibraryImportFolder", path);
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(e.display.getActiveShell());
                        DatabaseImportRunnable databaseImportRunnable = new DatabaseImportRunnable(file);
                        try {
                            dialog.run(false, false, (IRunnableWithProgress)databaseImportRunnable);
                            IMassSpectra massSpectra = databaseImportRunnable.getMassSpectra();
                            if (massSpectra.size() > 500) {
                                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Import", (String)("Do you really want to import " + massSpectra.size() + " target entries?"))) {
                                    TargetFieldEditor.this.addTargetTemplates(massSpectra);
                                }
                            } else {
                                TargetFieldEditor.this.addTargetTemplates(massSpectra);
                            }
                            TargetFieldEditor.this.setTableViewerInput();
                        }
                        catch (InvocationTargetException e1) {
                            logger.warn((Object)e1);
                        }
                        catch (InterruptedException e1) {
                            logger.warn((Object)e1);
                        }
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private Button createButtonImport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Import");
        button.setToolTipText("Import a target list.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8);
                fileDialog.setText("Target List");
                fileDialog.setFilterExtensions(new String[]{TargetFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{TargetFieldEditor.FILTER_NAME});
                fileDialog.setFilterPath(TargetFieldEditor.this.preferenceStore.getString("targetTemplateLibraryImportFolder"));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    File file = new File(pathname);
                    String path = file.getParentFile().getAbsolutePath();
                    TargetFieldEditor.this.preferenceStore.putValue("targetTemplateLibraryImportFolder", path);
                    TargetFieldEditor.this.targetTemplates.importItems(file);
                    TargetFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonExport(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText("Export");
        button.setToolTipText("Export the target list.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText("Target List");
                fileDialog.setFilterExtensions(new String[]{TargetFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{TargetFieldEditor.FILTER_NAME});
                fileDialog.setFileName(TargetFieldEditor.FILE_NAME);
                fileDialog.setFilterPath(TargetFieldEditor.this.preferenceStore.getString("targetTemplateLibraryImportFolder"));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    File file = new File(pathname);
                    String path = file.getParentFile().getAbsolutePath();
                    TargetFieldEditor.this.preferenceStore.putValue("targetTemplateLibraryImportFolder", path);
                    if (TargetFieldEditor.this.targetTemplates.exportItems(file)) {
                        MessageDialog.openInformation((Shell)button.getShell(), (String)"Target List", (String)"The target list has been exported successfully.");
                    } else {
                        MessageDialog.openWarning((Shell)button.getShell(), (String)"Target List", (String)"Something went wrong to export the target list.");
                    }
                }
            }
        });
        return button;
    }

    private void addTargetTemplates(IMassSpectra massSpectra) {
        for (IScanMSD scanMSD : massSpectra.getList()) {
            if (!(scanMSD instanceof ILibraryMassSpectrum)) continue;
            ILibraryMassSpectrum libraryMassSpectrum = (ILibraryMassSpectrum)scanMSD;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            TargetTemplate targetTemplate = new TargetTemplate();
            targetTemplate.setName(libraryInformation.getName());
            targetTemplate.setCasNumber(libraryInformation.getCasNumber());
            targetTemplate.setComments(libraryInformation.getComments());
            targetTemplate.setContributor(libraryInformation.getContributor());
            targetTemplate.setReferenceId(libraryInformation.getReferenceIdentifier());
            this.targetTemplates.add((ITargetTemplate)targetTemplate);
        }
        this.setTableViewerInput();
    }

    private void setTableViewerInput() {
        this.targetTemplateListUI.setInput(this.targetTemplates.values());
    }

    protected void doLoad() {
        String entries = this.getPreferenceStore().getString(this.getPreferenceName());
        this.targetTemplates.load(entries);
        this.setTableViewerInput();
    }

    protected void doLoadDefault() {
        String entries = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.targetTemplates.loadDefault(entries);
        this.setTableViewerInput();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.targetTemplates.save());
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns >= 2) {
            GridData gridData = (GridData)this.composite.getLayoutData();
            gridData.horizontalSpan = numColumns - 1;
            gridData.grabExcessHorizontalSpace = true;
        }
    }
}

