/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakTargetsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof IIdentificationTarget) {
            IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
            float rating = identificationTarget.getComparisonResult().getRating();
            if (rating >= 90.0f) {
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_up.gif", "16x16");
            }
            if (rating >= 70.0f) {
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_equal.gif", "16x16");
            }
            return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_down.gif", "16x16");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IIdentificationTarget) {
            IIdentificationTarget identificationEntry = (IIdentificationTarget)element;
            ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
            IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
            switch (columnIndex) {
                case 0: {
                    text = libraryInformation.getName();
                    break;
                }
                case 1: {
                    text = this.decimalFormat.format(comparisonResult.getMatchFactor());
                    break;
                }
                case 2: {
                    text = this.decimalFormat.format(comparisonResult.getReverseMatchFactor());
                    break;
                }
                case 3: {
                    text = this.decimalFormat.format(comparisonResult.getMatchFactorDirect());
                    break;
                }
                case 4: {
                    text = this.decimalFormat.format(comparisonResult.getReverseMatchFactorDirect());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }
}

