/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.QuantCompoundListUI;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class QuantCompoundEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private QuantCompoundListUI tableViewer;
    private String column;
    private String[] calibrationMethods = new String[]{CalibrationMethod.LINEAR.toString(), CalibrationMethod.QUADRATIC.toString(), CalibrationMethod.AVERAGE.toString()};

    public QuantCompoundEditingSupport(QuantCompoundListUI tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.tableViewer = tableViewer;
        this.setCellEditor(column);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block42: {
            if (!(element instanceof IQuantitationCompound)) break block42;
            IQuantitationCompound compound = (IQuantitationCompound)element;
            switch (this.column) {
                case "Name": {
                    return compound.getName();
                }
                case "Chemical Class": {
                    return compound.getChemicalClass();
                }
                case "Concentration Unit": {
                    return compound.getConcentrationUnit();
                }
                case "Calibration Method": {
                    String item = compound.getCalibrationMethod().toString();
                    int i = 0;
                    while (i < this.calibrationMethods.length) {
                        if (this.calibrationMethods[i].equals(item)) {
                            return i;
                        }
                        ++i;
                    }
                    return 0;
                }
                case "Cross Zero": {
                    return compound.isCrossZero();
                }
                case "Use TIC": {
                    return compound.isUseTIC();
                }
                case "Retention Time (RT)": {
                    return Double.toString((double)compound.getRetentionTimeWindow().getRetentionTime() / 60000.0);
                }
                case "RT (-)": {
                    return Double.toString((double)compound.getRetentionTimeWindow().getAllowedNegativeDeviation() / 60000.0);
                }
                case "RT (+)": {
                    return Double.toString((double)compound.getRetentionTimeWindow().getAllowedPositiveDeviation() / 60000.0);
                }
                case "Retention Index (RI)": {
                    return Float.toString(compound.getRetentionIndexWindow().getRetentionIndex());
                }
                case "RI (-)": {
                    return Float.toString(compound.getRetentionIndexWindow().getAllowedNegativeDeviation());
                }
                case "RI (+)": {
                    return Float.toString(compound.getRetentionIndexWindow().getAllowedPositiveDeviation());
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block40: {
            if (!(element instanceof IQuantitationCompound)) break block40;
            IQuantitationCompound compound = (IQuantitationCompound)element;
            switch (this.column) {
                case "Name": {
                    String name = (String)value;
                    if (this.tableViewer.containsName(name)) break;
                    compound.setName(name);
                    break;
                }
                case "Chemical Class": {
                    compound.setChemicalClass((String)value);
                    break;
                }
                case "Concentration Unit": {
                    compound.setConcentrationUnit((String)value);
                    break;
                }
                case "Calibration Method": {
                    String calibrationMethod = this.calibrationMethods[(Integer)value];
                    compound.setCalibrationMethod(CalibrationMethod.valueOf((String)calibrationMethod));
                    break;
                }
                case "Cross Zero": {
                    compound.setUseCrossZero(((Boolean)value).booleanValue());
                    break;
                }
                case "Use TIC": {
                    compound.setUseTIC(((Boolean)value).booleanValue());
                    break;
                }
                case "Retention Time (RT)": {
                    double retentionTime = this.getValue(value, 0.0);
                    if (!(retentionTime >= 0.0)) break;
                    compound.getRetentionTimeWindow().setRetentionTime((int)(retentionTime * 60000.0));
                    break;
                }
                case "RT (-)": {
                    double allowedNegativeDeviationRT = this.getValue(value, 0.0);
                    if (!(allowedNegativeDeviationRT >= 0.0)) break;
                    compound.getRetentionTimeWindow().setAllowedNegativeDeviation((float)((int)(allowedNegativeDeviationRT * 60000.0)));
                    break;
                }
                case "RT (+)": {
                    double allowedPositiveDeviationRT = this.getValue(value, 0.0);
                    if (!(allowedPositiveDeviationRT >= 0.0)) break;
                    compound.getRetentionTimeWindow().setAllowedPositiveDeviation((float)((int)(allowedPositiveDeviationRT * 60000.0)));
                    break;
                }
                case "Retention Index (RI)": {
                    float retentionIndex = this.getValue(value, 0.0f);
                    if (!(retentionIndex >= 0.0f)) break;
                    compound.getRetentionIndexWindow().setRetentionIndex(retentionIndex);
                    break;
                }
                case "RI (-)": {
                    float allowedNegativeDeviationRI = this.getValue(value, 0.0f);
                    if (!(allowedNegativeDeviationRI >= 0.0f)) break;
                    compound.getRetentionIndexWindow().setAllowedNegativeDeviation(allowedNegativeDeviationRI);
                    break;
                }
                case "RI (+)": {
                    float allowedPositiveDeviationRI = this.getValue(value, 0.0f);
                    if (!(allowedPositiveDeviationRI >= 0.0f)) break;
                    compound.getRetentionIndexWindow().setAllowedPositiveDeviation(allowedPositiveDeviationRI);
                }
            }
            this.tableViewer.refresh();
        }
    }

    private float getValue(Object value, float def) {
        float result = def;
        if (value instanceof String) {
            try {
                result = Float.parseFloat((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private double getValue(Object value, double def) {
        double result = def;
        if (value instanceof String) {
            try {
                result = Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private void setCellEditor(String column) {
        switch (column) {
            case "Cross Zero": 
            case "Use TIC": {
                this.cellEditor = new CheckboxCellEditor((Composite)this.tableViewer.getTable());
                break;
            }
            case "Calibration Method": {
                this.cellEditor = new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), new String[]{CalibrationMethod.LINEAR.toString(), CalibrationMethod.QUADRATIC.toString(), CalibrationMethod.AVERAGE.toString()}, 8);
                break;
            }
            default: {
                this.cellEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
            }
        }
    }
}

