/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class QuantCompoundListFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = ".*" + searchText + ".*";
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof IQuantitationCompound) {
            IQuantitationCompound quantitationCompound = (IQuantitationCompound)element;
            String name = quantitationCompound.getName();
            String chemicalClass = quantitationCompound.getChemicalClass();
            if (!this.caseSensitive) {
                this.searchText = this.searchText.toLowerCase();
                name = name.toLowerCase();
                chemicalClass = chemicalClass.toLowerCase();
            }
            if (name.matches(this.searchText)) {
                return true;
            }
            if (chemicalClass.matches(this.searchText)) {
                return true;
            }
        }
        return false;
    }
}

