/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ScanSignalListFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = searchText;
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IScanSignalWSD scanSignalWSD;
        IScanCSD scanCSD;
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (!this.caseSensitive) {
            this.searchText = this.searchText.toLowerCase();
        }
        if (element instanceof IIon) {
            IIon ion = (IIon)element;
            IIonTransition ionTransition = ion.getIonTransition();
            if (ionTransition != null) {
                if (Double.toString(ionTransition.getQ3Ion()).contains(this.searchText)) {
                    return true;
                }
                if (Integer.toString(ionTransition.getQ1Ion()).contains(this.searchText)) {
                    return true;
                }
            } else if (Double.toString(ion.getIon()).contains(this.searchText)) {
                return true;
            }
        } else if (element instanceof IScanCSD ? Float.toString((scanCSD = (IScanCSD)element).getTotalSignal()).contains(this.searchText) : element instanceof IScanSignalWSD && Double.toString((scanSignalWSD = (IScanSignalWSD)element).getWavelength()).contains(this.searchText)) {
            return true;
        }
        return false;
    }
}

