/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.identifier.ITargetTemplate;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class TargetTemplateEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;

    public TargetTemplateEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block16: {
            if (!(element instanceof ITargetTemplate)) break block16;
            ITargetTemplate targetTemplate = (ITargetTemplate)element;
            switch (this.column) {
                case "CAS": {
                    return targetTemplate.getCasNumber();
                }
                case "Comments": {
                    return targetTemplate.getComments();
                }
                case "Contributor": {
                    return targetTemplate.getContributor();
                }
                case "Reference ID": {
                    return targetTemplate.getReferenceId();
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block16: {
            if (!(element instanceof ITargetTemplate)) break block16;
            ITargetTemplate targetTemplate = (ITargetTemplate)element;
            switch (this.column) {
                case "CAS": {
                    targetTemplate.setCasNumber((String)value);
                    break;
                }
                case "Comments": {
                    targetTemplate.setComments((String)value);
                    break;
                }
                case "Contributor": {
                    targetTemplate.setContributor((String)value);
                    break;
                }
                case "Reference ID": {
                    targetTemplate.setReferenceId((String)value);
                }
            }
            this.tableViewer.refresh();
        }
    }
}

