/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.identifier.ITargetTemplate;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TargetTemplateLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String NAME = "Name";
    public static final String CAS = "CAS";
    public static final String COMMENTS = "Comments";
    public static final String CONTRIBUTOR = "Contributor";
    public static final String REFERENCE_ID = "Reference ID";
    public static final String[] TITLES = new String[]{"Name", "CAS", "Comments", "Contributor", "Reference ID"};
    public static final int[] BOUNDS = new int[]{200, 100, 100, 100, 100};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ITargetTemplate) {
            ITargetTemplate targetTemplate = (ITargetTemplate)element;
            switch (columnIndex) {
                case 0: {
                    text = targetTemplate.getName();
                    break;
                }
                case 1: {
                    text = targetTemplate.getCasNumber();
                    break;
                }
                case 2: {
                    text = targetTemplate.getComments();
                    break;
                }
                case 3: {
                    text = targetTemplate.getContributor();
                    break;
                }
                case 4: {
                    text = targetTemplate.getReferenceId();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/targets.gif", "16x16");
    }
}

