/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.SupplierEditorSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SequenceFileRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(SequenceFileRunnable.class);
    private ISupplierEditorSupport supplierEditorSupport = new SupplierEditorSupport(DataType.SEQ);
    private File file;
    private List<File> files;

    public SequenceFileRunnable(File file) {
        this.file = file;
    }

    public List<File> getSequenceFiles() {
        return this.files;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> xFiles = Files.list(Paths.get(this.file.toString(), new String[0]));){
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Import Sequences", (int)2);
                try {
                    subMonitor.worked(1);
                    this.files = this.getSequenceFiles(this.file, new ArrayList<File>(), subMonitor.split((int)xFiles.count()));
                    subMonitor.worked(1);
                }
                finally {
                    subMonitor.done();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    private List<File> getSequenceFiles(File file, List<File> files, SubMonitor subMonitor) {
        if (subMonitor.isCanceled()) {
            return files;
        }
        subMonitor.worked(1);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subfile = fileArray[n2];
                if (subfile.isDirectory()) {
                    files = this.getSequenceFiles(subfile, files, subMonitor);
                } else if (this.isSequenceFile(subfile)) {
                    files.add(subfile);
                }
                ++n2;
            }
        } else if (this.isSequenceFile(file)) {
            files.add(file);
        }
        return files;
    }

    private boolean isSequenceFile(File file) {
        return this.supplierEditorSupport.isSupplierFile(file) && this.supplierEditorSupport.isMatchMagicNumber(file);
    }
}

