/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IMeasurementInfo;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.nmr.converter.core.ScanConverterNMR;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IOverviewUpdateSupport;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.xir.converter.core.ScanConverterXIR;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public abstract class AbstractOverviewUpdateSupport
extends AbstractDataUpdateSupport
implements IOverviewUpdateSupport {
    private static final Logger logger = Logger.getLogger(AbstractOverviewUpdateSupport.class);
    private String filePath = "";

    public AbstractOverviewUpdateSupport(MPart part) {
        super(part);
    }

    @Override
    public void registerEvents() {
        this.registerEvent("chromatogram/msd/update/rawfile", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/csd/update/rawfile", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/wsd/update/rawfile", "org.eclipse.e4.data");
        this.registerEvent("scan/nmr/update/rawfile", "org.eclipse.e4.data");
        this.registerEvent("scan/xir/update/rawfile", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/msd/update/overview", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/csd/update/overview", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/wsd/update/overview", "org.eclipse.e4.data");
        this.registerEvent("scan/nmr/update/overview", "org.eclipse.e4.data");
        this.registerEvent("scan/xir/update/overview", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/msd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/csd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/wsd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/xxd/load/chromatogramselection", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/xxd/unload/chromatogramselection", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/xxd/update/none", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        if (objects.size() > 0) {
            Object object = objects.get(0);
            if (object instanceof IChromatogramOverview) {
                IChromatogramOverview chromatogramOverview = (IChromatogramOverview)object;
                this.update(chromatogramOverview);
            } else if (object instanceof IChromatogramSelection) {
                IChromatogramSelection chromatogramSelection = (IChromatogramSelection)object;
                this.updateChromatogramSelection(chromatogramSelection);
            } else if (object instanceof File) {
                File file = (File)object;
                this.updateFile(file, topic);
            } else if (topic.equals("chromatogram/xxd/update/none")) {
                this.update(null);
            }
        }
    }

    private void updateChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        if (chromatogram != null) {
            this.update(chromatogram);
        }
    }

    private void updateFile(File file, String topic) {
        if (!file.getAbsolutePath().equals(this.filePath)) {
            this.filePath = file.getAbsolutePath();
            if (topic.equals("scan/nmr/update/rawfile")) {
                IProcessingInfo processingInfo = ScanConverterNMR.convert((File)file, (IProgressMonitor)new NullProgressMonitor());
                Object data = processingInfo.getProcessingResult();
                if (data instanceof IMeasurementInfo) {
                    this.update(data);
                }
            } else if (topic.equals("scan/xir/update/rawfile")) {
                IProcessingInfo processingInfo = ScanConverterXIR.convert((File)file, (IProgressMonitor)new NullProgressMonitor());
                Object data = processingInfo.getProcessingResult();
                if (data instanceof IMeasurementInfo) {
                    this.update(data);
                }
            } else {
                IChromatogramOverview chromatogramOverview = this.getChromatogramOverview(file, topic);
                if (chromatogramOverview != null) {
                    this.update(chromatogramOverview);
                }
            }
        }
    }

    private IChromatogramOverview getChromatogramOverview(File file, String topic) {
        IChromatogramOverview chromatogramOverview = null;
        IProcessingInfo processingInfo = null;
        switch (topic) {
            case "chromatogram/msd/update/rawfile": {
                processingInfo = ChromatogramConverterMSD.getInstance().convertOverview(file, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            case "chromatogram/csd/update/rawfile": {
                processingInfo = ChromatogramConverterCSD.getInstance().convertOverview(file, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            case "chromatogram/wsd/update/rawfile": {
                processingInfo = ChromatogramConverterWSD.getInstance().convertOverview(file, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        if (processingInfo != null) {
            chromatogramOverview = (IChromatogramOverview)processingInfo.getProcessingResult();
        }
        return chromatogramOverview;
    }
}

