/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.segments;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class AnalysisSegmentColorScheme {
    public static final AnalysisSegmentColorScheme CHROMATOGRAM = new AnalysisSegmentColorScheme(new RGB(200, 190, 183), new RGB(227, 222, 219), new RGB(172, 157, 147), new RGB(145, 124, 111));
    public static final AnalysisSegmentColorScheme ANALYSIS = new AnalysisSegmentColorScheme(new RGB(215, 244, 227), new RGB(175, 233, 198), new RGB(135, 222, 170), new RGB(95, 211, 141));
    public static final AnalysisSegmentColorScheme NOISE = new AnalysisSegmentColorScheme(new RGB(246, 213, 255), new RGB(238, 170, 255), new RGB(229, 128, 255), new RGB(170, 0, 212));
    private final RGB[] rgb;

    private AnalysisSegmentColorScheme(RGB ... colours) {
        this.rgb = colours;
    }

    public AnalysisSegmentColors create(GC gc) {
        return new AnalysisSegmentColors(gc);
    }

    public final class AnalysisSegmentColors {
        private final Color[] colors;

        public AnalysisSegmentColors(GC gc) {
            this.colors = new Color[AnalysisSegmentColorScheme.this.rgb.length];
            int i = 0;
            while (i < AnalysisSegmentColorScheme.this.rgb.length) {
                this.colors[i] = new Color(gc.getDevice(), AnalysisSegmentColorScheme.this.rgb[i]);
                ++i;
            }
        }

        public void dispose() {
            Color[] colorArray = this.colors;
            int n = this.colors.length;
            int n2 = 0;
            while (n2 < n) {
                Color color = colorArray[n2];
                color.dispose();
                ++n2;
            }
        }

        public Color get(Type type) {
            return this.colors[type.ordinal()];
        }
    }

    public static enum Type {
        SEGMENT_EVEN,
        SEGMENT_ODD,
        LINE,
        SELECTION;

    }
}

