/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.ISignal;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.VisibilityTargetDisplaySettings;
import org.eclipse.core.runtime.IAdaptable;

public class SignalTargetReference
implements TargetReference,
IAdaptable {
    public static final String TYPE_SCAN = "Scan";
    public static final String TYPE_PEAK = "Peak";
    private static final NumberFormat FORMAT = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private final ISignal signal;
    private final String name;
    private final String id;
    private final String type;
    private final ITargetSupplier supplier;

    public <X extends ISignal & ITargetSupplier> SignalTargetReference(X item, String type, String name) {
        this.signal = item;
        this.supplier = item;
        this.type = type;
        this.name = name;
        this.id = String.valueOf(type) + "." + name;
    }

    public Set<IIdentificationTarget> getTargets() {
        return this.supplier.getTargets();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public ISignal getSignal() {
        return this.signal;
    }

    public static List<SignalTargetReference> getScanReferences(List<? extends IScan> items) {
        ArrayList<SignalTargetReference> list = new ArrayList<SignalTargetReference>();
        for (IScan iScan : items) {
            if (iScan == null || iScan.getTargets().isEmpty()) continue;
            String name = FORMAT.format((double)iScan.getRetentionTime() / 60000.0);
            list.add(new SignalTargetReference(iScan, TYPE_SCAN, name));
        }
        return list;
    }

    public static List<SignalTargetReference> getPeakReferences(Collection<? extends IPeak> items) {
        return SignalTargetReference.getPeakReferences(items, null);
    }

    public static List<SignalTargetReference> getPeakReferences(Collection<? extends IPeak> items, Function<? super IPeak, IScan> ticProvider) {
        ArrayList<SignalTargetReference> list = new ArrayList<SignalTargetReference>();
        for (IPeak iPeak : items) {
            Set targets = iPeak.getTargets();
            if ((iPeak == null || targets.size() <= 0 && iPeak.getName() == null) && iPeak.getClassifier().size() <= 0) continue;
            String name = FORMAT.format((double)iPeak.getPeakModel().getRetentionTimeAtPeakMaximum() / 60000.0);
            if (ticProvider == null) {
                list.add(new SignalTargetReference(iPeak, TYPE_PEAK, name));
                continue;
            }
            list.add(new TICSignalTargetReference(iPeak, ticProvider.apply((IPeak)iPeak), TYPE_PEAK, name));
        }
        return list;
    }

    public static Predicate<TargetReference> createVisibleFilter(final TargetDisplaySettings settings) {
        if (settings == null) {
            return always -> true;
        }
        Predicate<TargetReference> typePredicate = new Predicate<TargetReference>(){

            @Override
            public boolean test(TargetReference reference) {
                if (settings != null) {
                    if (SignalTargetReference.TYPE_PEAK.equals(reference.getType())) {
                        return settings.isShowPeakLabels();
                    }
                    if (SignalTargetReference.TYPE_SCAN.equals(reference.getType())) {
                        return settings.isShowScanLables();
                    }
                }
                return true;
            }
        };
        if (settings instanceof VisibilityTargetDisplaySettings) {
            VisibilityTargetDisplaySettings visibility = (VisibilityTargetDisplaySettings)settings;
            return typePredicate.and(visibility::isVisible);
        }
        return typePredicate;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.signal)) {
            return adapter.cast(this.signal);
        }
        return null;
    }

    private static final class TICSignalTargetReference
    extends SignalTargetReference {
        private final IScan tic;

        public TICSignalTargetReference(IPeak peak, IScan tic, String type, String name) {
            super(peak, type, name);
            this.tic = tic;
        }

        @Override
        public ISignal getSignal() {
            if (this.tic != null) {
                return this.tic;
            }
            return super.getSignal();
        }

        @Override
        public <T> T getAdapter(Class<T> adapter) {
            T t = super.getAdapter(adapter);
            if (t == null && adapter.isInstance(this.tic)) {
                return adapter.cast(this.tic);
            }
            return t;
        }
    }
}

