/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.EnumSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.LibraryServiceRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ChartConfigSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.AxisConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ComparisonScanUIConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ConfigurableUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanChartUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedComparisonScanUI
implements ConfigurableUI<ComparisonScanUIConfig> {
    private static final Logger logger = Logger.getLogger(ExtendedComparisonScanUI.class);
    private static final float NORMALIZATION_FACTOR = 1000.0f;
    private static final String OPTION_UPDATE_SCAN_1 = "UPDATE_SCAN_1";
    private static final String OPTION_UPDATE_SCAN_2 = "UPDATE_SCAN_2";
    private static final String OPTION_LIBRARY_SEARCH = "LIBRARY_SEARCH";
    private static final String PREFIX_U = "[U]";
    private static final String PREFIX_R = "[R]";
    private static final String PREFIX_UR = "[U-R]";
    private static final String LABEL_UR_NORMAL = "[U,R]";
    private static final String LABEL_UR_DIFFERENCE = "[U-R]";
    private static final String TITLE_UNKNOWN = "UNKNOWN MS";
    private static final String TITLE_REFERENCE = "REFERENCE MS";
    private static final String POSTFIX_NONE = "";
    private static final String POSTFIX_SHIFTED = " SHIFTED (+1)";
    private Button buttonOptimizedScan;
    private Label labelInfoReference;
    private Composite toolbarInfoUnknown;
    private ScanChartUI scanChartUI;
    private Label labelInfoComparison;
    private Composite toolbarInfoReference;
    private Composite toolbarOptions;
    private IScanMSD scan1 = null;
    private IScanMSD scan2 = null;
    private IScanMSD scan1Optimized = null;
    private IScanMSD scan2Optimized = null;
    private String displayOption = "LIBRARY_SEARCH";
    private boolean displayDifference = false;
    private boolean displayMirrored = true;
    private boolean displayShifted = false;
    private final ScanDataSupport scanDataSupport = new ScanDataSupport();
    private Composite toolbarMain;
    private Composite toolbarInfo;
    private final int style;
    private Composite comparisonInfo;

    @Inject
    public ExtendedComparisonScanUI(Composite parent, int style) {
        this.style = style;
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        Display.getDefault().asyncExec(this::updateChart);
    }

    public void update(IScanMSD scanMSD) {
        if (this.displayOption.equals(OPTION_UPDATE_SCAN_1)) {
            this.scan1Optimized = null;
            if (scanMSD == null) {
                this.scan1 = null;
                this.buttonOptimizedScan.setEnabled(false);
            } else {
                try {
                    this.scan1 = scanMSD.makeDeepCopy().normalize(1000.0f);
                    this.buttonOptimizedScan.setEnabled(true);
                }
                catch (CloneNotSupportedException e) {
                    logger.warn((Object)e);
                }
            }
            Display.getDefault().asyncExec(this::updateChart);
        } else if (this.displayOption.equals(OPTION_UPDATE_SCAN_2)) {
            this.scan2Optimized = null;
            if (scanMSD == null) {
                this.scan2 = null;
                this.buttonOptimizedScan.setEnabled(false);
            } else {
                try {
                    this.scan2 = scanMSD.makeDeepCopy().normalize(1000.0f);
                    this.buttonOptimizedScan.setEnabled(true);
                }
                catch (CloneNotSupportedException e) {
                    logger.warn((Object)e);
                }
            }
            Display.getDefault().asyncExec(this::updateChart);
        }
    }

    public void update(IScanMSD unknownMassSpectrum, IIdentificationTarget identificationTarget) {
        if (this.displayOption.equals(OPTION_LIBRARY_SEARCH)) {
            this.scan1 = ExtendedComparisonScanUI.copyScan(unknownMassSpectrum);
            this.scan1Optimized = null;
            this.scan2Optimized = null;
            LibraryServiceRunnable runnable = new LibraryServiceRunnable(identificationTarget, new Consumer<IScanMSD>(){

                @Override
                public void accept(IScanMSD referenceMassSpectrum) {
                    ExtendedComparisonScanUI.this.scan2 = ExtendedComparisonScanUI.copyScan(referenceMassSpectrum);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ExtendedComparisonScanUI.this.buttonOptimizedScan.setEnabled(true);
                            ExtendedComparisonScanUI.this.updateChart();
                        }
                    });
                }
            });
            try {
                if (runnable.requireProgressMonitor()) {
                    DisplayUtils.executeInUserInterfaceThread(() -> {
                        ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.scanChartUI.getShell());
                        monitor.run(true, true, (IRunnableWithProgress)runnable);
                        return null;
                    });
                } else {
                    DisplayUtils.executeBusy(() -> {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                        return null;
                    });
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "Update scan failed", (Throwable)e));
            }
        }
    }

    private static IScanMSD copyScan(IScanMSD scan) {
        if (scan != null) {
            try {
                return scan.makeDeepCopy().normalize(1000.0f);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    private void updateChart() {
        if (this.scan1 != null && this.scan2 != null) {
            if (this.displayDifference) {
                this.updateScanComparisonDifference(this.displayMirrored, this.displayShifted);
            } else {
                this.updateScanComparisonNormal(this.displayMirrored, this.displayShifted);
            }
        } else {
            this.updateScanNormal();
        }
    }

    private void updateScanComparisonNormal(boolean mirrored, boolean shifted) {
        IScanMSD scan_1 = this.scan1Optimized != null ? this.scan1Optimized : this.scan1;
        IScanMSD scan_2 = this.scan2Optimized != null ? this.scan2Optimized : this.scan2;
        this.labelInfoReference.setText(this.scanDataSupport.getMassSpectrumLabel(scan_1, PREFIX_U, TITLE_UNKNOWN, POSTFIX_NONE));
        this.labelInfoComparison.setText(this.scanDataSupport.getMassSpectrumLabel(scan_2, PREFIX_R, TITLE_REFERENCE, shifted ? POSTFIX_SHIFTED : POSTFIX_NONE));
        if (shifted) {
            ScanMSD scan2Shifted = new ScanMSD();
            IExtractedIonSignal extractedIonSignalScan2 = scan_2.getExtractedIonSignal();
            int startIon = extractedIonSignalScan2.getStartIon();
            int stopIon = extractedIonSignalScan2.getStopIon();
            int ion = startIon;
            while (ion <= stopIon) {
                float abundance = extractedIonSignalScan2.getAbundance(ion);
                if (abundance > 0.0f) {
                    scan2Shifted.addIon(this.getIon(ion + 1, abundance));
                }
                ++ion;
            }
            this.scanChartUI.setInput((IScan)scan_1, (IScan)scan2Shifted, mirrored);
        } else {
            this.scanChartUI.setInput((IScan)scan_1, (IScan)scan_2, mirrored);
        }
    }

    private void updateScanComparisonDifference(boolean mirrored, boolean shifted) {
        IScanMSD scan_1 = this.scan1Optimized != null ? this.scan1Optimized : this.scan1;
        IScanMSD scan_2 = this.scan2Optimized != null ? this.scan2Optimized : this.scan2;
        this.labelInfoReference.setText(this.scanDataSupport.getMassSpectrumLabel(scan_1, "[U-R]", TITLE_UNKNOWN, POSTFIX_NONE));
        this.labelInfoComparison.setText(this.scanDataSupport.getMassSpectrumLabel(scan_2, "[U-R]", TITLE_REFERENCE, shifted ? POSTFIX_SHIFTED : POSTFIX_NONE));
        IExtractedIonSignal extractedIonSignalReference = scan_1.getExtractedIonSignal();
        IExtractedIonSignal extractedIonSignalComparison = scan_2.getExtractedIonSignal();
        int startIon = extractedIonSignalReference.getStartIon() < extractedIonSignalComparison.getStartIon() ? extractedIonSignalReference.getStartIon() : extractedIonSignalComparison.getStartIon();
        int stopIon = extractedIonSignalReference.getStopIon() > extractedIonSignalComparison.getStopIon() ? extractedIonSignalReference.getStopIon() : extractedIonSignalComparison.getStopIon();
        ScanMSD scanDifference1 = new ScanMSD();
        ScanMSD scanDifference2 = new ScanMSD();
        int ion = startIon;
        while (ion <= stopIon) {
            float abundance = extractedIonSignalReference.getAbundance(ion) - extractedIonSignalComparison.getAbundance(ion);
            if (abundance > 0.0f) {
                scanDifference1.addIon(this.getIon(ion, abundance));
            } else if (abundance < 0.0f) {
                abundance *= -1.0f;
                if (shifted) {
                    scanDifference2.addIon(this.getIon(ion + 1, abundance));
                } else {
                    scanDifference2.addIon(this.getIon(ion, abundance));
                }
            }
            ++ion;
        }
        this.scanChartUI.setInput((IScan)scanDifference1, (IScan)scanDifference2, mirrored);
    }

    private void updateScanNormal() {
        this.labelInfoReference.setText(POSTFIX_NONE);
        this.labelInfoComparison.setText(POSTFIX_NONE);
        if (this.scan1 != null) {
            IScanMSD scan_1 = this.scan1Optimized != null ? this.scan1Optimized : this.scan1;
            this.labelInfoReference.setText(this.scanDataSupport.getMassSpectrumLabel(scan_1, PREFIX_U, TITLE_UNKNOWN, POSTFIX_NONE));
            this.scanChartUI.setInput((IScan)scan_1);
        } else if (this.scan2 != null) {
            IScanMSD scan_2 = this.scan2Optimized != null ? this.scan2Optimized : this.scan2;
            this.labelInfoReference.setText(this.scanDataSupport.getMassSpectrumLabel(scan_2, PREFIX_U, TITLE_UNKNOWN, POSTFIX_NONE));
            this.scanChartUI.setInput((IScan)scan_2);
        } else {
            this.scanChartUI.setInput(null);
        }
    }

    private IIon getIon(int mz, float abundance) {
        Ion ion = null;
        try {
            ion = new Ion((double)mz, abundance);
        }
        catch (AbundanceLimitExceededException e) {
            logger.warn((Object)e);
        }
        catch (IonLimitExceededException e) {
            logger.warn((Object)e);
        }
        return ion;
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfoUnknown = this.createToolbarInfoUnknown(parent);
        this.toolbarOptions = this.createToolbarOptions(parent);
        this.createScanChart(parent);
        this.toolbarInfoReference = this.createToolbarInfoReference(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoUnknown, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoReference, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarOptions, (boolean)false);
    }

    private void createToolbarMain(Composite parent) {
        this.toolbarMain = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        this.toolbarMain.setLayoutData((Object)gridData);
        this.toolbarMain.setLayout((Layout)new GridLayout(6, false));
        this.createButtonToggleToolbarInfo(this.toolbarMain);
        this.createButtonToggleToolbarOptions(this.toolbarMain);
        this.createResetButton(this.toolbarMain);
        this.createSaveButton(this.toolbarMain);
        this.buttonOptimizedScan = this.createOptimizedScanButton(this.toolbarMain);
        this.createSettingsButton(this.toolbarMain);
    }

    private Composite createToolbarInfoUnknown(Composite parent) {
        this.toolbarInfo = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        this.toolbarInfo.setLayoutData((Object)gridData);
        this.toolbarInfo.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoReference = new Label(this.toolbarInfo, 0);
        this.labelInfoReference.setText(POSTFIX_NONE);
        this.labelInfoReference.setLayoutData((Object)new GridData(768));
        return this.toolbarInfo;
    }

    private Composite createToolbarOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createUpdateGroup(composite);
        this.createDisplayGroup(composite);
        this.createMirrorOptionSection(composite);
        return composite;
    }

    private void createUpdateGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setBackground(Colors.WHITE);
        group.setText(POSTFIX_NONE);
        group.setToolTipText("Select the display option.");
        group.setLayout((Layout)new RowLayout(256));
        group.setLayoutData((Object)new GridData(768));
        Button updateScan1 = new Button((Composite)group, 16);
        updateScan1.setText("Scan 1");
        updateScan1.setSelection(this.displayOption.equals(OPTION_UPDATE_SCAN_1));
        updateScan1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.displayOption = ExtendedComparisonScanUI.OPTION_UPDATE_SCAN_1;
                ExtendedComparisonScanUI.this.updateChart();
            }
        });
        Button updateScan2 = new Button((Composite)group, 16);
        updateScan2.setText("Scan 2");
        updateScan2.setSelection(this.displayOption.equals(OPTION_UPDATE_SCAN_2));
        updateScan2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.displayOption = ExtendedComparisonScanUI.OPTION_UPDATE_SCAN_2;
                ExtendedComparisonScanUI.this.updateChart();
            }
        });
        Button updateLibraryScan = new Button((Composite)group, 16);
        updateLibraryScan.setText("Library Search");
        updateLibraryScan.setSelection(this.displayOption.equals(OPTION_LIBRARY_SEARCH));
        updateLibraryScan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.displayOption = ExtendedComparisonScanUI.OPTION_LIBRARY_SEARCH;
                ExtendedComparisonScanUI.this.updateChart();
            }
        });
    }

    private void createDisplayGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(POSTFIX_NONE);
        group.setToolTipText("Select the display pre-processing.");
        group.setBackground(Colors.WHITE);
        group.setText(POSTFIX_NONE);
        group.setLayout((Layout)new RowLayout(256));
        group.setLayoutData((Object)new GridData(768));
        Button buttonNormalModus = new Button((Composite)group, 16);
        buttonNormalModus.setText(LABEL_UR_NORMAL);
        buttonNormalModus.setToolTipText("Use the normal modus.");
        buttonNormalModus.setSelection(!this.displayDifference);
        buttonNormalModus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.displayDifference = false;
                ExtendedComparisonScanUI.this.updateChart();
            }
        });
        Button buttonDifferenceModus = new Button((Composite)group, 16);
        buttonDifferenceModus.setText("[U-R]");
        buttonDifferenceModus.setToolTipText("Use the difference modus.");
        buttonDifferenceModus.setSelection(this.displayDifference);
        buttonDifferenceModus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.displayDifference = true;
                ExtendedComparisonScanUI.this.updateChart();
            }
        });
    }

    private void createMirrorOptionSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        final Button buttonMirrored = new Button(composite, 8);
        buttonMirrored.setText(POSTFIX_NONE);
        buttonMirrored.setToolTipText("Set whether the data shall be displayed normal or mirrored.");
        buttonMirrored.setImage(ApplicationImageFactory.getInstance().getImage(this.displayMirrored ? "org.eclipse.chemclipse.rcp.ui.icons/mirroredMassSpectrum.gif" : "org.eclipse.chemclipse.rcp.ui.icons/massSpectrum.gif", "16x16"));
        buttonMirrored.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.displayMirrored = !ExtendedComparisonScanUI.this.displayMirrored;
                buttonMirrored.setImage(ApplicationImageFactory.getInstance().getImage(ExtendedComparisonScanUI.this.displayMirrored ? "org.eclipse.chemclipse.rcp.ui.icons/mirroredMassSpectrum.gif" : "org.eclipse.chemclipse.rcp.ui.icons/massSpectrum.gif", "16x16"));
                ExtendedComparisonScanUI.this.updateChart();
            }
        });
        final Button buttonShifted = new Button(composite, 8);
        buttonShifted.setText(POSTFIX_NONE);
        buttonShifted.setToolTipText("Set whether the data shall be shifted or not.");
        buttonShifted.setImage(ApplicationImageFactory.getInstance().getImage(this.displayShifted ? "org.eclipse.chemclipse.rcp.ui.icons/shiftedMassSpectrum.gif" : "org.eclipse.chemclipse.rcp.ui.icons/massSpectrum.gif", "16x16"));
        buttonShifted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.displayShifted = !ExtendedComparisonScanUI.this.displayShifted;
                buttonShifted.setImage(ApplicationImageFactory.getInstance().getImage(ExtendedComparisonScanUI.this.displayShifted ? "org.eclipse.chemclipse.rcp.ui.icons/shiftedMassSpectrum.gif" : "org.eclipse.chemclipse.rcp.ui.icons/massSpectrum.gif", "16x16"));
                ExtendedComparisonScanUI.this.updateChart();
            }
        });
    }

    private void createScanChart(Composite parent) {
        this.scanChartUI = new ScanChartUI(parent, this.style);
        this.scanChartUI.setLayoutData(new GridData(1808));
    }

    private Composite createToolbarInfoReference(Composite parent) {
        this.comparisonInfo = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        this.comparisonInfo.setLayoutData((Object)gridData);
        this.comparisonInfo.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoComparison = new Label(this.comparisonInfo, 0);
        this.labelInfoComparison.setText(POSTFIX_NONE);
        this.labelInfoComparison.setLayoutData((Object)new GridData(768));
        return this.comparisonInfo;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the reference/comparison info toolbar.");
        button.setText(POSTFIX_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.toggleCompositeVisibility((Composite)ExtendedComparisonScanUI.this.toolbarInfoUnknown);
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedComparisonScanUI.this.toolbarInfoReference);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarOptions(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the options toolbar.");
        button.setText(POSTFIX_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedComparisonScanUI.this.toolbarOptions);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the chart.");
        button.setText(POSTFIX_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedComparisonScanUI.this.reset();
            }
        });
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save both mass spectra.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/saveas.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExtendedComparisonScanUI.this.scan1 != null) {
                        DatabaseFileSupport.saveMassSpectrum((Shell)DisplayUtils.getShell(), (IScanMSD)ExtendedComparisonScanUI.this.scan1, (String)"UnknownMS");
                    }
                    if (ExtendedComparisonScanUI.this.scan2 != null) {
                        DatabaseFileSupport.saveMassSpectrum((Shell)DisplayUtils.getShell(), (IScanMSD)ExtendedComparisonScanUI.this.scan2, (String)"ReferenceMS");
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private Button createOptimizedScanButton(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Show optimized scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/plus.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExtendedComparisonScanUI.this.scan1.getOptimizedMassSpectrum() != null) {
                        ExtendedComparisonScanUI.this.scan1Optimized = ExtendedComparisonScanUI.this.scan1.getOptimizedMassSpectrum().makeDeepCopy().normalize(1000.0f);
                    }
                    if (ExtendedComparisonScanUI.this.scan2.getOptimizedMassSpectrum() != null) {
                        ExtendedComparisonScanUI.this.scan2Optimized = ExtendedComparisonScanUI.this.scan2.getOptimizedMassSpectrum().makeDeepCopy().normalize(1000.0f);
                    }
                    button.setEnabled(false);
                    ExtendedComparisonScanUI.this.updateChart();
                }
                catch (CloneNotSupportedException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText(POSTFIX_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageScans()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedComparisonScanUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void reset() {
        this.scan1Optimized = null;
        this.scan2Optimized = null;
        this.buttonOptimizedScan.setEnabled(true);
        this.updateChart();
    }

    private void applySettings() {
        this.updateChart();
    }

    @Override
    public ComparisonScanUIConfig getConfig() {
        return new ComparisonScanUIConfig(){
            ChartConfigSupport axisSupport;
            {
                this.axisSupport = new ChartConfigSupport(ExtendedComparisonScanUI.this.scanChartUI, EnumSet.of(AxisConfig.ChartAxis.PRIMARY_X, AxisConfig.ChartAxis.PRIMARY_Y, AxisConfig.ChartAxis.SECONDARY_Y));
            }

            @Override
            public void setToolbarVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedComparisonScanUI.this.toolbarMain, (boolean)visible);
            }

            @Override
            public boolean hasToolbarInfo() {
                return true;
            }

            @Override
            public void setToolbarInfoVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedComparisonScanUI.this.toolbarInfo, (boolean)visible);
            }

            @Override
            public boolean isToolbarVisible() {
                return ExtendedComparisonScanUI.this.toolbarMain.isVisible();
            }

            @Override
            public void setAxisLabelVisible(AxisConfig.ChartAxis axis, boolean visible) {
                this.axisSupport.setAxisLabelVisible(axis, visible);
            }

            @Override
            public void setAxisVisible(AxisConfig.ChartAxis axis, boolean visible) {
                this.axisSupport.setAxisVisible(axis, visible);
            }

            @Override
            public boolean hasAxis(AxisConfig.ChartAxis axis) {
                return this.axisSupport.hasAxis(axis);
            }

            @Override
            public void setDisplayOption(ComparisonScanUIConfig.DisplayOption option) {
                ExtendedComparisonScanUI.this.displayOption = option.name();
            }

            @Override
            public void setDisplayDifference(boolean displayDifference) {
                ExtendedComparisonScanUI.this.displayDifference = displayDifference;
                ExtendedComparisonScanUI.this.updateChart();
            }

            @Override
            public void setDisplayMirrored(boolean displayMirrored) {
                ExtendedComparisonScanUI.this.displayMirrored = displayMirrored;
                ExtendedComparisonScanUI.this.updateChart();
            }

            @Override
            public void setDisplayShifted(boolean displayShifted) {
                ExtendedComparisonScanUI.this.displayShifted = displayShifted;
                ExtendedComparisonScanUI.this.updateChart();
            }

            @Override
            public void setComparisonLabelVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedComparisonScanUI.this.comparisonInfo, (boolean)visible);
            }
        };
    }
}

