/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.InternalStandard;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.ConcentrationValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.NameValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.ResponseFactorValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.InternalStandardsListUI;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExtendedInternalStandardsUI {
    private static final Logger logger = Logger.getLogger(ExtendedInternalStandardsUI.class);
    private static final String MENU_CATEGORY_ISTD = "Internal Standards";
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_ADD = "ACTION_ADD";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private Composite toolbarInfo;
    private Composite toolbarModify;
    private Composite toolbarAdd;
    private Label labelPeak;
    private Label labelInputErrors;
    private ComboViewer comboName;
    private Text textConcentration;
    private Text textResponseFactor;
    private Button buttonInsert;
    private NameValidator nameValidator;
    private ControlDecoration nameControlDecoration;
    private ConcentrationValidator concentrationValidator;
    private ControlDecoration concentrationControlDecoration;
    private ResponseFactorValidator responseFactorValidator;
    private ControlDecoration responseFactorControlDecoration;
    private Button buttonCancel;
    private Button buttonAdd;
    private Button buttonDelete;
    private InternalStandardsListUI internalStandardsListUI;
    private IPeak peak;
    private PeakDataSupport peakDataSupport = new PeakDataSupport();

    @Inject
    public ExtendedInternalStandardsUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updatePeak();
    }

    public void update(IPeak peak) {
        this.peak = peak;
        this.updatePeak();
    }

    private void updatePeak() {
        String editInformation = this.internalStandardsListUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
        this.labelPeak.setText(String.valueOf(this.peakDataSupport.getPeakLabel(this.peak)) + " - " + editInformation);
        if (this.peak != null) {
            this.internalStandardsListUI.setInput(this.peak.getInternalStandards());
            TargetExtendedComparator comparator = new TargetExtendedComparator(SortOrder.DESC);
            ArrayList targets = new ArrayList(this.peak.getTargets());
            Collections.sort(targets, comparator);
            ArrayList<String> names = new ArrayList<String>();
            for (IIdentificationTarget target : targets) {
                String name = target.getLibraryInformation().getName();
                if (names.contains(name)) continue;
                names.add(name);
            }
            this.comboName.setInput(names);
        } else {
            this.internalStandardsListUI.setInput(null);
            this.comboName.setInput(Collections.emptyList());
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.toolbarModify = this.createToolbarModify(parent);
        this.toolbarAdd = this.createToolbarAdd(parent);
        this.createInternalStandardsList(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarAdd, (boolean)false);
        this.internalStandardsListUI.setEditEnabled(false);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleToolbarModify(composite);
        this.createButtonToggleEditModus(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelPeak = new Label(composite, 0);
        this.labelPeak.setText("");
        this.labelPeak.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarModify(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createErrorLabel(composite);
        this.buttonCancel = this.createButtonCancel(composite);
        this.buttonAdd = this.createButtonAdd(composite);
        this.buttonDelete = this.createButtonDelete(composite);
        return composite;
    }

    private void createErrorLabel(Composite parent) {
        this.labelInputErrors = new Label(parent, 0);
        this.labelInputErrors.setLayoutData((Object)new GridData(768));
    }

    private Button createButtonCancel(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Cancel Operation");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/cancel.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedInternalStandardsUI.this.enableButtonFields(ExtendedInternalStandardsUI.ACTION_CANCEL);
                ExtendedInternalStandardsUI.this.clearLabelInputErrors();
                PartSupport.setCompositeVisibility((Composite)ExtendedInternalStandardsUI.this.toolbarAdd, (boolean)false);
            }
        });
        return button;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add Internal Standard");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedInternalStandardsUI.this.peak != null) {
                    if (ExtendedInternalStandardsUI.this.peak.getIntegratedArea() == 0.0) {
                        ExtendedInternalStandardsUI.this.setLabelInputError("The peak area is 0. Please integrate the peak(s) first.");
                    } else {
                        ExtendedInternalStandardsUI.this.clearLabelInputErrors();
                        ExtendedInternalStandardsUI.this.enableButtonFields(ExtendedInternalStandardsUI.ACTION_ADD);
                        PartSupport.setCompositeVisibility((Composite)ExtendedInternalStandardsUI.this.toolbarAdd, (boolean)true);
                    }
                } else {
                    ExtendedInternalStandardsUI.this.setLabelInputError("No peak has been selected yet.");
                }
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete Internal Standard");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedInternalStandardsUI.this.deleteInternalStandards(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Composite createToolbarAdd(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createTextName(composite);
        this.createTextConcentration(composite);
        this.createTextResponseFactor(composite);
        this.buttonInsert = this.createButtonInsert(composite);
        return composite;
    }

    private void createTextName(Composite parent) {
        this.comboName = new ComboViewer(parent, 2048);
        Combo combo = this.comboName.getCombo();
        this.comboName.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboName.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        combo.setText("");
        combo.setToolTipText("Name of the internal standard (ISTD).");
        combo.setLayoutData((Object)new GridData(768));
        this.nameValidator = new NameValidator();
        this.nameControlDecoration = new ControlDecoration((Control)combo, 16512);
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtendedInternalStandardsUI.this.validate(ExtendedInternalStandardsUI.this.nameValidator, ExtendedInternalStandardsUI.this.nameControlDecoration, ExtendedInternalStandardsUI.this.comboName);
            }
        });
    }

    private void createTextConcentration(Composite parent) {
        this.textConcentration = new Text(parent, 2048);
        this.textConcentration.setText("");
        this.textConcentration.setToolTipText("Concentration, e.g. 10 mg/L");
        GridData gridData = new GridData(768);
        gridData.minimumWidth = 80;
        this.textConcentration.setLayoutData((Object)gridData);
        this.concentrationValidator = new ConcentrationValidator();
        this.concentrationControlDecoration = new ControlDecoration((Control)this.textConcentration, 16512);
        this.textConcentration.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtendedInternalStandardsUI.this.validate(ExtendedInternalStandardsUI.this.concentrationValidator, ExtendedInternalStandardsUI.this.concentrationControlDecoration, ExtendedInternalStandardsUI.this.textConcentration);
            }
        });
    }

    private void createTextResponseFactor(Composite parent) {
        this.textResponseFactor = new Text(parent, 2048);
        this.textResponseFactor.setText("1.0");
        this.textResponseFactor.setToolTipText("Response Factor");
        GridData gridData = new GridData(768);
        gridData.minimumWidth = 50;
        this.textResponseFactor.setLayoutData((Object)gridData);
        this.responseFactorValidator = new ResponseFactorValidator();
        this.responseFactorControlDecoration = new ControlDecoration((Control)this.textResponseFactor, 16512);
        this.textResponseFactor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtendedInternalStandardsUI.this.validate(ExtendedInternalStandardsUI.this.responseFactorValidator, ExtendedInternalStandardsUI.this.responseFactorControlDecoration, ExtendedInternalStandardsUI.this.textResponseFactor);
            }
        });
    }

    private Button createButtonInsert(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Insert Internal Standard");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedInternalStandardsUI.this.addInternalStandard(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedInternalStandardsUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedInternalStandardsUI.this.toolbarModify);
                if (!visible) {
                    PartSupport.setCompositeVisibility((Composite)ExtendedInternalStandardsUI.this.toolbarAdd, (boolean)false);
                }
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedInternalStandardsUI.this.internalStandardsListUI.isEditEnabled();
                ExtendedInternalStandardsUI.this.internalStandardsListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedInternalStandardsUI.this.updatePeak();
            }
        });
        return button;
    }

    private void createInternalStandardsList(Composite parent) {
        this.internalStandardsListUI = new InternalStandardsListUI(parent, 68354);
        Table table = this.internalStandardsListUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedInternalStandardsUI.this.enableButtonFields(ExtendedInternalStandardsUI.ACTION_SELECT);
            }
        });
        Shell shell = this.internalStandardsListUI.getTable().getShell();
        ITableSettings tableSettings = this.internalStandardsListUI.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        this.addKeyEventProcessors(shell, tableSettings);
        this.internalStandardsListUI.applySettings(tableSettings);
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Internal Standard(s)";
            }

            public String getCategory() {
                return ExtendedInternalStandardsUI.MENU_CATEGORY_ISTD;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedInternalStandardsUI.this.deleteInternalStandards(shell);
            }
        });
    }

    private void addKeyEventProcessors(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addKeyEventProcessor(new IKeyEventProcessor(){

            public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
                if (e.keyCode == 127) {
                    ExtendedInternalStandardsUI.this.deleteInternalStandards(shell);
                }
            }
        });
    }

    private void deleteInternalStandards(Shell shell) {
        if (this.peak != null) {
            MessageBox messageBox = new MessageBox(shell, 196);
            messageBox.setText("Delete Internal Standard(s)");
            messageBox.setMessage("Would you like to delete the selected internal standard(s)?");
            if (messageBox.open() == 64) {
                this.enableButtonFields(ACTION_DELETE);
                for (Object object : this.internalStandardsListUI.getStructuredSelection()) {
                    if (!(object instanceof IInternalStandard)) continue;
                    this.deleteInternalStandard((IInternalStandard)object);
                }
                this.updatePeak();
            }
        }
    }

    private void deleteInternalStandard(IInternalStandard internalStandard) {
        if (this.peak != null) {
            this.peak.removeInternalStandard(internalStandard);
        }
    }

    private void addInternalStandard(Shell shell) {
        if (this.peak == null) {
            MessageBox messageBox = new MessageBox(shell, 40);
            messageBox.setText("Add Internal Standard (ISTD)");
            messageBox.setMessage("No peak has been selected.");
            messageBox.open();
        } else {
            try {
                boolean isInputValid = false;
                String name = "";
                double concentration = 0.0;
                String concentrationUnit = "";
                double responseFactor = 0.0;
                isInputValid = this.validate((IValidator)this.nameValidator, this.nameControlDecoration, this.comboName);
                name = this.nameValidator.getName();
                if (isInputValid) {
                    isInputValid = this.validate((IValidator)this.concentrationValidator, this.concentrationControlDecoration, this.textConcentration);
                    concentration = this.concentrationValidator.getConcentration();
                    concentrationUnit = this.concentrationValidator.getUnit();
                }
                if (isInputValid) {
                    isInputValid = this.validate((IValidator)this.responseFactorValidator, this.responseFactorControlDecoration, this.textResponseFactor);
                    responseFactor = this.responseFactorValidator.getResponseFactor();
                }
                if (isInputValid) {
                    String chemicalClass = "";
                    InternalStandard internalStandard = new InternalStandard(name, concentration, concentrationUnit, responseFactor);
                    internalStandard.setChemicalClass(chemicalClass);
                    if (this.peak.getInternalStandards().contains(internalStandard)) {
                        MessageBox messageBox = new MessageBox(shell, 296);
                        messageBox.setText("Add Internal Standard (ISTD)");
                        messageBox.setMessage("The Internal Standard (ISTD) exists already.");
                        messageBox.open();
                    } else {
                        this.peak.addInternalStandard((IInternalStandard)internalStandard);
                        this.comboName.getCombo().setText("");
                        this.textConcentration.setText("");
                        this.textResponseFactor.setText("1.0");
                        this.enableButtonFields(ACTION_INITIALIZE);
                        this.updatePeak();
                    }
                }
            }
            catch (Exception e1) {
                logger.warn((Object)e1);
                MessageBox messageBox = new MessageBox(shell, 40);
                messageBox.setText("Add Internal Standard (ISTD)");
                messageBox.setMessage("Please check the content, response factor and unit values.");
                messageBox.open();
            }
        }
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_ADD": {
                this.buttonCancel.setEnabled(true);
                this.comboName.getCombo().setEnabled(true);
                this.textConcentration.setEnabled(true);
                this.textResponseFactor.setEnabled(true);
                this.buttonInsert.setEnabled(true);
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                this.buttonCancel.setEnabled(true);
                if (this.internalStandardsListUI.getTable().getSelectionIndex() >= 0) {
                    this.buttonDelete.setEnabled(true);
                    break;
                }
                this.buttonDelete.setEnabled(false);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.comboName.getCombo().setEnabled(enabled);
        this.textConcentration.setEnabled(enabled);
        this.textResponseFactor.setEnabled(enabled);
        this.buttonInsert.setEnabled(enabled);
    }

    private void clearLabelInputErrors() {
        this.labelInputErrors.setText("");
        this.labelInputErrors.setBackground(null);
    }

    private void setLabelInputError(String message) {
        this.labelInputErrors.setText(message);
        this.labelInputErrors.setBackground(Colors.YELLOW);
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Text text) {
        return this.validate(validator, controlDecoration, text.getText());
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, ComboViewer combo) {
        return this.validate(validator, controlDecoration, combo.getCombo().getText());
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, String text) {
        IStatus status = validator.validate((Object)text);
        if (status.isOK()) {
            controlDecoration.hide();
            this.clearLabelInputErrors();
            return true;
        }
        this.setLabelInputError(status.getMessage());
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText("Input Error");
        controlDecoration.show();
        return false;
    }
}

