/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.QuantitationListUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ExtendedQuantitationListUI {
    private Composite toolbarInfo;
    private Label labelInfo;
    private QuantitationListUI quantitationListUI;
    private IPeak peak;
    private PeakDataSupport peakDataSupport = new PeakDataSupport();

    @Inject
    public ExtendedQuantitationListUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateObject();
    }

    public void update(IPeak peak) {
        this.peak = peak;
        this.labelInfo.setText(this.peakDataSupport.getPeakLabel(peak));
        this.updateObject();
    }

    private void updateObject() {
        if (this.peak != null) {
            this.quantitationListUI.setInput(this.peak);
        } else {
            this.quantitationListUI.clear();
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.createQuantitationTable(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createButtonToggleToolbarInfo(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private QuantitationListUI createQuantitationTable(Composite parent) {
        this.quantitationListUI = new QuantitationListUI(parent, 68354);
        this.quantitationListUI.getTable().setLayoutData((Object)new GridData(1808));
        Shell shell = this.quantitationListUI.getTable().getShell();
        ITableSettings tableSettings = this.quantitationListUI.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        this.addKeyEventProcessors(shell, tableSettings);
        this.quantitationListUI.applySettings(tableSettings);
        return this.quantitationListUI;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedQuantitationListUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Quantitation Entrie(s)";
            }

            public String getCategory() {
                return "";
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedQuantitationListUI.this.deleteQuantitationEntries(shell);
            }
        });
    }

    private void addKeyEventProcessors(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addKeyEventProcessor(new IKeyEventProcessor(){

            public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
                if (e.keyCode == 127) {
                    ExtendedQuantitationListUI.this.deleteQuantitationEntries(shell);
                }
            }
        });
    }

    private void deleteQuantitationEntries(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Delete Quantitation Entrie(s)");
        messageBox.setMessage("Would you like to delete the selected quantitation entrie(s)?");
        if (messageBox.open() == 64) {
            for (Object object : this.quantitationListUI.getStructuredSelection()) {
                if (!(object instanceof IQuantitationEntry)) continue;
                this.deleteQuantitationEntry((IQuantitationEntry)object);
            }
            this.updateObject();
        }
    }

    private void deleteQuantitationEntry(IQuantitationEntry quantitationEntry) {
        if (this.peak != null) {
            this.peak.removeQuantitationEntry(quantitationEntry);
        }
    }
}

