/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartXIR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EditorUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageOverlay;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.chemclipse.xir.model.core.ISignalXIR;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ExtendedXIROverlayUI {
    private ChartXIR chartXIR;
    private EditorUpdateSupport editorUpdateSupport = new EditorUpdateSupport();
    private List<IScanXIR> scanSelections = new ArrayList<IScanXIR>();
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private IColorScheme colorSchemeNormal = Colors.getColorScheme((String)this.preferenceStore.getString("colorSchemeDisplayOverlay"));

    @Inject
    public ExtendedXIROverlayUI(Composite parent) {
        this.initialize(parent);
    }

    public void update() {
        this.scanSelections = this.editorUpdateSupport.getScanSelectionsXIR();
        this.refreshUpdateOverlayChart();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.createOverlayChart(parent);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createToggleChartLegendButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private void createToggleChartLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedXIROverlayUI.this.chartXIR.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Overlay");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedXIROverlayUI.this.applyOverlaySettings();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageOverlay preferencePageOverlay = new PreferencePageOverlay();
                preferencePageOverlay.setTitle("Overlay Settings");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePageOverlay));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedXIROverlayUI.this.applyOverlaySettings();
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void createOverlayChart(Composite parent) {
        this.chartXIR = new ChartXIR(parent, 2048);
        this.chartXIR.setLayoutData(new GridData(1808));
    }

    private void applyOverlaySettings() {
    }

    private void refreshUpdateOverlayChart() {
        this.chartXIR.deleteSeries();
        if (this.scanSelections.size() > 0) {
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            int i = 1;
            Color color = this.colorSchemeNormal.getColor();
            for (IScanXIR scanXIR : this.scanSelections) {
                ILineSeriesData lineSeriesData = this.getLineSeriesData(scanXIR, "XIR_" + i++);
                ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                lineSeriesSettings.setLineColor(color);
                lineSeriesSettings.setEnableArea(false);
                lineSeriesDataList.add(lineSeriesData);
                color = this.colorSchemeNormal.getNextColor();
            }
            this.chartXIR.addSeriesData(lineSeriesDataList, LineChart.MEDIUM_COMPRESSION);
        }
    }

    private ILineSeriesData getLineSeriesData(IScanXIR scanXIR, String id) {
        LineSeriesData lineSeriesData = new LineSeriesData(this.getSeriesDataProcessed(scanXIR, id));
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setLineColor(Colors.RED);
        lineSeriesSettings.setEnableArea(true);
        return lineSeriesData;
    }

    private ISeriesData getSeriesDataProcessed(IScanXIR scanXIR, String id) {
        double[] ySeries;
        double[] xSeries;
        if (scanXIR != null) {
            int size = scanXIR.getProcessedSignals().size();
            xSeries = new double[size];
            ySeries = new double[size];
            int index = 0;
            for (ISignalXIR scanSignal : scanXIR.getProcessedSignals()) {
                xSeries[index] = scanSignal.getWavelength();
                ySeries[index] = scanSignal.getIntensity();
                ++index;
            }
        } else {
            xSeries = new double[]{};
            ySeries = new double[]{};
        }
        return new SeriesData(xSeries, ySeries, id);
    }
}

