/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import java.util.Iterator;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.pcr.model.core.IChannel;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.pcr.model.core.Position;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.swt.ISelectionHandler;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PCRWell
extends Composite {
    private Color colorInactive = Colors.GRAY;
    private Color colorActive = Colors.RED;
    private Label label;
    private ISelectionHandler selectionHandler;
    private IWell well;

    public PCRWell(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setWell(IWell well) {
        this.well = well;
        this.refresh();
    }

    public IWell getWell() {
        return this.well;
    }

    public void refresh() {
        if (this.well != null) {
            String wellInfo = this.getWellInfo(this.well);
            Position position = this.well.getPosition();
            this.setContent(String.valueOf(position.getRow()) + position.getColumn(), wellInfo);
            if (this.well != null) {
                if (this.well.isEmptyMeasurement() || !this.well.isActiveSubset()) {
                    this.setColors(Colors.GRAY, Colors.DARK_GRAY, Colors.WHITE);
                } else if (this.well.isPositiveMeasurement()) {
                    this.setColors(Colors.RED, Colors.DARK_RED, Colors.WHITE);
                } else {
                    this.setColors(Colors.GREEN, Colors.DARK_GREEN, Colors.BLACK);
                }
            }
        } else {
            this.setContent("", "No well data available.");
            this.setColors(Colors.GRAY, Colors.GRAY, Colors.BLACK);
        }
    }

    public void setSelectionHandler(ISelectionHandler selectionHandler) {
        this.selectionHandler = selectionHandler;
    }

    public void setContent(String text, String tooltip) {
        this.label.setText(text);
        this.label.setToolTipText(tooltip);
        this.setToolTipText(tooltip);
    }

    public void setColors(Color colorInactive, Color colorActive, Color colorText) {
        this.colorInactive = colorInactive;
        this.colorActive = colorActive;
        this.setBackgroundColor(colorInactive);
        this.setForegroundColor(colorText);
    }

    public void setActive() {
        this.setBackgroundColor(this.colorActive);
    }

    public void setInactive() {
        this.setBackgroundColor(this.colorInactive);
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.setBackground(this.colorInactive);
        this.addControlListener((Control)this);
        this.addLabel(this);
    }

    private void setBackgroundColor(Color color) {
        this.setBackground(color);
        this.label.setBackground(color);
    }

    private void setForegroundColor(Color color) {
        this.setForeground(color);
        this.label.setForeground(color);
    }

    private Label addLabel(Composite parent) {
        this.label = new Label(parent, 0);
        this.label.setText("");
        this.label.setToolTipText("");
        this.label.setLayoutData((Object)this.getGridData());
        this.addControlListener((Control)this.label);
        return this.label;
    }

    private GridData getGridData() {
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        return gridData;
    }

    private void addControlListener(Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PCRWell.this.handleSelection();
            }
        });
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                PCRWell.this.handleSelection();
            }
        });
    }

    private void handleSelection() {
        if (this.selectionHandler != null) {
            this.selectionHandler.handleEvent();
        }
    }

    public String getWellInfo(IWell well) {
        String text = "";
        if (well != null) {
            if (well.isEmptyMeasurement()) {
                text = "Position " + this.getPosition(well);
            } else if (well.isActiveSubset()) {
                StringBuilder builder = new StringBuilder();
                builder.append(well.getSampleId());
                PCRWell.appendHeaderInfo(well, builder);
                this.appendCrossingPointInfo(well, builder);
                text = builder.toString();
            } else {
                String sampleSubset = well.getSampleSubset();
                text = sampleSubset.equals("") ? "--" : String.valueOf(sampleSubset) + " <" + this.getPosition(well) + ">";
            }
        }
        return text;
    }

    private static void appendHeaderInfo(IWell well, StringBuilder builder) {
        String sampleSubset = well.getSampleSubset();
        String targetName = well.getTargetName();
        builder.append("\n");
        builder.append(sampleSubset.equals("") ? "--" : sampleSubset);
        builder.append(" | ");
        builder.append(targetName.equals("") ? "--" : targetName);
    }

    private void appendCrossingPointInfo(IWell well, StringBuilder builder) {
        builder.append("\n");
        IChannel activeChannel = well.getActiveChannel();
        if (activeChannel == null) {
            Iterator iterator = well.getChannels().values().iterator();
            while (iterator.hasNext()) {
                IChannel channel = (IChannel)iterator.next();
                this.appendChannelCrossingPoint(channel, builder);
                if (!iterator.hasNext()) continue;
                builder.append(" | ");
            }
        } else {
            this.appendChannelCrossingPoint(activeChannel, builder);
        }
    }

    private void appendChannelCrossingPoint(IChannel channel, StringBuilder builder) {
        if (channel != null) {
            IPoint crossingPoint = channel.getCrossingPoint();
            if (crossingPoint != null && crossingPoint.getX() > 0.0) {
                DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();
                builder.append(decimalFormat.format(crossingPoint.getX()));
            } else {
                builder.append("--");
            }
        }
    }

    private int getPosition(IWell well) {
        return well.getPosition().getId() + 1;
    }
}

